;****************************************************************************
; Filename: CALLOC.ASM
;   Author: Peter Andersson
;  Version: 0.3
;  Created: 1995.03.10
;  Updated: 
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PVOID @calloc(ULONG items,ULONG size)
;  Comment: Allocates the first available memory block which is big enough
;           and clears it. The size to allocate is items*size.
;    Input: Eax - number of items to allocate
;           Edx - size of block to allocate in bytes
;  Returns: Pointer to the allocated block or 0 if it failed.
;****************************************************************************

        Include STDDEF.INC
        Include "MEMORY.INC"

        Codeseg

Proc    calloc ,2
                Imul    Eax,Edx
                Push    Eax
                Call    @malloc         ; Call the good ol' malloc
                POP     Ecx             ; Get size allocated
                TestZ   Eax             ; If malloc returned a NULL pointer
                Jz      @@Exit          ; exit immediately
                Push    Eax
                Clear   Edx             ; Get blocksize and clear the fill value
                Call    @memset
                Pop     Eax
@@Exit:         Ret
Endp    

        End
