;
;
;   Writen by Adam Seychell


.386

.model flat

            .CODE


comment $
ͻ
 returns EAX with the SQUARE ROOT of EAX.                        
                                                                 
 Uses newtons method:    Xn+1 = Xn -  f(Xn) / f'(Xn)             
    f'(x) is the derivitive of f(x)                              
                                                                 
 For square routes:  f(x) = x*x - ( Root value  i.e EAX)         
  so     f'(x) = 2x                                              
                                                                 
 For cube routes:  f(x) = x*x*x - ( Root value )                 
  so     f'(x) = 3x                                              
ͼ$
Public  SQRT

SQRT	Proc PASCAL USES EDI ECX EBP EDX EBX        

		mov edi,eax
;----- Get Estimated Root Value ( ebp = rough value of the sqrt of EAX ) ---
                bsr ecx,edi     ; Get bit number of highest NZ bit
                shr cl,1        ; Half this highest bit number
		mov ebp,edi     ; Rotate Root Value by
                shr ebp,cl      ;  the bit number to get a estimate root.


;----- Main Loop that makes EBP converge to the square root of EDI ------
 calc_sqrt_Loop:
        push EBP		; save x  so can check if x has converged
        mov  EBX,EBP
        shl  EBX,1		; ebx = f'(x) = 2x

        mov  EAX,EBP
        mul EBP
        sub  EAX,EDI		; eax = f(x) = X*X - Root_value
        sbb  EDX,0		; use 64bit subtract

        idiv  EBX               ; eax = f(Xn) / f'(Xn)

	sub  EBP,EAX		; ebp =   Xn+1   =   Xn - f(Xn) / f'(Xn)
        pop  EAX		; look at old value
        cmp  EBP,EAX		; loop only if new value is different
      jne calc_sqrt_Loop
;-------------------------- End of Loop --------------------------------

        mov eax,ebp     ; EBP now contians the square root of EDI
	ret
;
SQRT    Endp

        End
