Global _stdin_fstream    :FILE
Global _stdout_fstream   :FILE
Global _stderr_fstream   :FILE
Global _stdaux_fstream   :FILE
Global _stdprn_fstream   :FILE


ENODEV				= 1
ENOMEM				= 2


BUFSIZ              = 2048			; the default buffer size.
FOPEN_MAX           = 128			; you can guess.
_IOFBF				= 0
_IOLBF				= 1
_IONBF				= 2


Struc FILE
_mode           DB ?                ; opend file mode;
									;   Bit 0 = Readable
									;   Bit 1 = Writable
									;   Bit 2 = Binary enabled
									;   Bit 3 = Error flag
									;   Bit 4   0=availible / 1=used
_type			DB ?                ; Buffer type _IOFBF,_IONBF ,ect
_handle         DW ?                ; DOS file handle
_size           DD ?                ; current size of buffer
_buffersize     DD ?                ; maximum size of buffer
_position       DD ?                ; Current active position in buffer
_base           DD ?                ; pointer to data transfer buffer
Ends


stdin  EQU  (Offset _stdin_fstream)
stdout EQU  (Offset _stdout_fstream)
stderr EQU  (Offset _stderr_fstream)
stdaux EQU  (Offset _stdaux_fstream)
stdprn EQU  (Offset _stdprn_fstream)

_IOFBF = 0
_IOLBF = 1
_IONBF = 2


;/**** file stream functions *****/
PALfunction        fgetc        ; Get a single character
PALfunction        fputc        ; Put a single character
PALfunction        fgets        ; Get a single string
PALfunction        fputs        ; Put a single string
PALfunction        freopen      ; Reopen file handle
PALfunction        fopen        ; Open file
PALfunction        fclose       ; close file stream
PALfunction        fcloseall    ; close all files
PALfunction        fread
PALfunction        fwrite
PALfunction        ftell        ; get current seek position
PALfunction        fseek
PALfunction        fflush       ; flush buffers to file.
PALfunction        fflushall    ; flush all streams
;PALfunction       ferror
;PALfunction       clearerr
PALfunction        rewind       ; seek to beginning
PALfunction        setvbuf      ; set buffer of I/O stream
PALfunction        setbuf       ; set buffer of I/O stream
Global C fprintf:Near           ; Prints formatted to a file
;Global C fscanf:Near           ; Scans formatted file


PALfunction        strncmp


;/**** floating point math ******/
;PALfunction               fabs
;PALfunction               abs
;PALfunction               asin
;PALfunction               acos
;PALfunction               atan
;PALfunction               sin
;PALfunction               cos
;PALfunction               tan
;PALfunction               sinh
;PALfunction               cosh
;PALfunction               tanh
;PALfunction               sqrt
;PALfunction               pow
;PALfunction               exp
;PALfunction               log
;PALfunction               log10
;PALfunction               floor
;PALfunction               rand
;PALfunction               time
;PALfunction               vscanf
;PALfunction               scanf
;PALfunction               sscanf
PALfunction               memcmp




