/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
	.file "memset.s"
	.text
	.align	4
	.globl	_memset
_memset:
	pushl	%edi
        movl    8(%esp),%edi
        movl    12(%esp),%eax
        movl    16(%esp),%ecx
	cld

	# We will handle memsets of <= 15 bytes one byte at a time.
	# This avoids some extra overhead for small memsets, and
	# knowing we are setting > 15 bytes eliminates some annoying
	# checks in the "long move" case.
	cmpl	$15,%ecx
	jle	L3

	# Otherwise, tile the byte value out into %eax.
	# 0x41 -> 0x41414141, etc.
	movb	%al,%ah
	movl	%eax,%edx
	sall	$16,%eax
	movw	%dx,%ax
	jmp	L2

	# Handle any cruft necessary to get %edi long-aligned.
L1:	stosb
	decl	%ecx
L2:	testl	$3,%edi
	jnz	L1

	# Now slam out all of the longs.
	movl	%ecx,%edx
	shrl	$2,%ecx
L4:
        movl    %eax,(%edi)
        addl    $4,%edi
        decl    %ecx
        jnz     L4

	# Finally, handle any trailing cruft.  We know the high three bytes
	# of %ecx must be zero, so just put the "slop count" in the low byte.
	movb	%dl,%cl
	andb	$3,%cl
L3:     rep
        stosb
        popl    %edi
        movl    4(%esp),%eax
	ret
