/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/*
 * This is file REMOTDRV.C
 *
 * Copyright (c) 1994, 1995 Eli Zaretskii <eliz@is.elta.co.il>
 *
 * This software may be used freely so long as this copyright notice is
 * left intact.  There is no warranty on this software.
 *
 */
 
#include <errno.h>
#include <libc/dosio.h>
#include <dos.h>
 
int _is_remote_drive(int);
 
/* Return 1 if the named DRIVE is remote (i.e., networked) drive,
   0 if not.  Return -1 if the call failed.
   Call with drive NUMBER, not letter, i.e. 1 = 'A', 2 = 'B', etc.  */
 
int
_is_remote_drive(int drv_no)
{
  unsigned short d,ax;
  unsigned char  a;
  if (_get_dos_version(1) < 0x030a)
  {
    /* DOS versions before 3.1 don't support INT 21H/AX=4409H, but
       they don't support network, either.  So we just verify that
       this is a valid drive, and if so, return 0 (i.e., local
       drive).  */
    asm("movb  $0x1c,%%ah\n\
         int   $0x21"
        : "=a" (a)
        : "d" (drv_no + 1)
        : "eax","ebx","ecx","edx");
    if (a == 0xff)
    {
      /* INT 21H/AH=1CH doesn't return an error code, so fake one.  */
      errno = ENODEV;
      return -1;
    }
    return 0;
  }
 
  /* INT 21H/AX=4409H returns DX with 12th bit set, if drive is remote. */
  asm("movw $0x4409,%%ax\n\
       int  $0x21\n\
       sbbb %%bl,%%bl"
      : "=a" (ax), "=b" (a), "=d" (d)
      : "b" (drv_no + 1)
      : "eax","ebx","edx","cc");
  if (a)
  {
    errno = __doserr_to_errno(ax);
    return -1;
  }
  if (d & 0x1000)
    return 1;
  return 0;
}

