/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/dosio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <dos32api.h>

void _path_unix2dos(const char *path,char *dest,int space)
{
  char *o;

  if (path == 0)
  {
    errno = EFAULT;
    abort();
  }

  if (strcmp(path, "/dev/null") == 0)
    path = "nul";
  if (strcmp(path, "/dev/tty") == 0)
    path = "con";

  /* collapse multiple slashes to a single slash */
  for (o=dest; *path; path++)
  {
    if (path[0] != '/' || path[1] != '/')
    {
      *o=*path;
      o++;
      if (--space < 2) /* safety check */
    break;
    }
  }

  /* remove trailing slash if it doesn't
     represent the root directory */
  if (o-2 >= dest
      && *(o-1) == '/'
      && *(o-2) != ':')
    o--;

  /* null terminate it */
  *o=0;
}

void
_put_path(const char *path)
{
  _put_path2(path, 0);
}

void
_put_path2(const char *path, int offset)
{
  _path_unix2dos(path,(char *)__dos32_dos_buffer+offset,8192-offset);
}
