/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <dos32api.h>

#include <libc/dosio.h>

void (*__setmode_stdio_hook)(int fd, int mode); /* BSS to zero */

int
setmode(int handle, int mode)
{
  int oldmode, newmode,a,e;

  asm ("        movw $0x4400,%%ax\n\
        xorl %%edx,%%edx\n\
        int  $0x21\n\
        sbbl %%ebx,%%ebx"
        : "=a" (a), "=b" (e), "=d" (oldmode)
        : "b" (handle)
        : "eax", "ebx", "edx", "cc");
  if (e)
  {
    errno = __doserr_to_errno(a);
    return -1;
  }
  newmode = oldmode;

  if (mode & O_BINARY)
    newmode |= 0x20;
  else
    newmode &= ~0x20;

  if (oldmode & 0x80)	/* Only for character dev */
  {
    asm("         movw $0x4401,%%ax\n\
         movb $0,%%dh\n\
         movw %w2,%%bx\n\
         movw %b3,%%dl\n\
         int  $0x21\n\
         sbbl %%ebx,%%ebx"
        : "=a" (a), "=b" (e)
        : "g" (handle), "qm" (newmode)
        : "eax", "ebx", "edx", "cc");
    if (e)
    {
      errno = __doserr_to_errno(a);
      return -1;
    }
    if (handle == 0)
      __dos32_set_cbreak_mode(!(mode & O_BINARY));
  }

  oldmode = __file_handle_modes[handle] & (O_BINARY|O_TEXT);
  __file_handle_modes[handle] &= ~(O_BINARY|O_TEXT);
  __file_handle_modes[handle] |= (mode & (O_BINARY|O_TEXT));

  return oldmode;
}
