/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos32api.h>
#include <crt0.h>
#include <libc/dosio.h>
#include <libc/bss.h>

static int use_lfn_bss_count = -1;
static char use_lfn = 2;	/* 0 = no, 1 = yes, 2 = find out */

char _use_lfn(void)
{
  if (use_lfn_bss_count != __bss_count)
  {
    _dos32_regs r;
    char *lfnenv;

    use_lfn_bss_count = __bss_count;

    if(_crt0_startup_flags & _CRT0_FLAG_NO_LFN) {
      use_lfn = 0;
      return 0;
    }

    lfnenv = getenv("LFN");
    if(lfnenv && (tolower(lfnenv[0]) == 'n'))
    {
      use_lfn = 0;
      return 0;
    }
     
    r.eax = 0x7147;
    r.edx = 0;                     /* Current drive */
    r.esi = 0;
    r.ds = __dos32_dos_buffer_seg;
    r.flags = 1;      /* Set the carry */
    __dos32_call_realmode_int(0x21, &r,0);
    if((r.eax & 0xffff) == 0x7100 || r.flags & 1)
    {
      _crt0_startup_flags |= _CRT0_FLAG_NO_LFN;
      use_lfn = 0;
    } else
      use_lfn = 1;
  }
  return use_lfn;
}
