/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <errno.h>
#include <sys/stat.h>
#include <dos32api.h>
#include <unistd.h>
#include <libc/dosio.h>
 
int
mkdir(const char *dirname, mode_t mode)
{
  _dos32_regs r;
  char dummy[256];

  if(_USE_LFN) {
    _put_path(dirname);
    r.ds  = __dos32_dos_buffer_seg;
    r.edx = 0;
    r.eax = 0x7139;
    __dos32_call_realmode_int(0x21, &r,0);
  }
  else {
    _path_unix2dos(dirname,&dummy[0],256);
    asm("mov $0x39,%%ah;int $0x21;sbbl %%edx,%%edx"
        : "=a" (r.eax), "=d" (r.flags)
        : "d" (&dummy)
        : "eax","edx","cc");
  }
  
 
  if (r.flags & 1)
  {
    errno = __doserr_to_errno(r.eax);
    if (errno == EACCES)
    {
      /* see if the directory existed, in which case
	 we should return EEXIST - DJ */
      if (access(dirname, D_OK) == 0)
	errno = EEXIST;
    }
    return -1;
  }

  /* DOS ignores directory permissions, and mkdir is stub'd,
     so rather than stub chmod also, just skip it.   DJ */
/*  if (chmod(dirname, mode))
    return -1; */
  return 0;
}

