#include <stdio.h>
#include <stdlib.h>
#include <libc/secret.h>
#include <setjmp.h>
#include <dos32api.h>
#include <signal.h>
#include <unistd.h>
#include <dos.h>

void fail_func(char *msg,int line);
#define fail(c,s) if (c) fail_func(s,__LINE__)
#define S_MALLOC  0x100
#define S_REALLOC 0x200

extern void *end;
extern void *edata;

int _crt0_startup_flags=0x20 | 0x2000;
int _crt0_alloc_mem=0x20000;
char _crt0_alloc_dma=4;

void newalarm(int a);

void newalarm(int a)
{
    printf("SIGALRM handler called !\n");
}

#define f fflush(stdout);

void main()
{
    char *mallocvar;
    jmp_buf jump_test;
    int i;
    _cl_farptr farptr;
    union REGS r;
    unsigned long along;
    fprintf(stderr,"\
NOTE: If you are piping the output to a file, you will have to wait now about\n\
      14 seconds.\n");
    printf("startup statistics:\n\
  heap_start: %08lx heap_top: %08lx heap_max: %08lx\n\
  free heap: %08lx (%d kB)\n\
  psp address: %08p env address: %08p\n\
  data ends at: %08p bss end at: %08p\n"
    ,__heap_start,
    __heap_top,__heap_max,__heap_max-__heap_top,(__heap_max-__heap_top)/1024,
    __psp_address,__env_address,
    &edata,&end);
    printf("testing malloc - %x bytes\n  heap_top before malloc: %08lx\n",
           S_MALLOC,__heap_top);
    mallocvar=(char *)malloc(0x100);
    fail(!mallocvar,"MALLOC");
    printf("  after malloc - heap_top: %08lx pointer value: %08p\n",
           __heap_top,mallocvar);
    printf("testing realloc - %x bytes\n",S_REALLOC);
    realloc(mallocvar,0x200);
    fail(!mallocvar,"REALLOC");
    printf("  after realloc - heap_top: %08lx pointer value: %08p\n",
           __heap_top,mallocvar);
    printf("testing free\n");
    free(mallocvar);
    printf("testing setjmp/longjmp\n  setting jump\n");
    i=setjmp(jump_test);
    printf("  regs after %d. setjmp:\n\
    eax: %08lx ebx: %08lx ecx: %08lx edx: %08lx\n\
    esi: %08lx edi: %08lx ebp: %08lx esp: %08lx\n\
    ds: %04x es: %04x fs: %04x gs: %04x ss: %04x\n\
    cs:eip - %04x:%08lx  eflags: %08lx\n",i+1,jump_test->__eax,jump_test->__ebx,
    jump_test->__ecx,jump_test->__edx,jump_test->__esi,jump_test->__edi,
    jump_test->__ebp,jump_test->__esp,jump_test->__ds,jump_test->__es,
    jump_test->__fs,jump_test->__gs,jump_test->__ss,jump_test->__cs,
    jump_test->__eip,jump_test->__eflags);
    f
    if (!i) {
      printf("  jumping...\n");
      longjmp(jump_test,1);
    }
    printf("testing signal handling\n  setting SIGALRM\n");
    signal(SIGALRM,&newalarm);
    printf("  raising SIGALRM\n");
    raise(SIGALRM);
    printf("  setting alarm to 4 secs\n");
    alarm(4);
    printf("  waiting 6 secs\n");
    sleep(6);
    printf("  resetting SIGALRM to default\n");
    signal(SIGALRM,SIG_DFL);
    printf("  setting alarm to 4 secs (no message should be output after 4 secs)\n");
    alarm(4);
    printf("  waiting 6 secs\n");
    sleep(6);
    printf("testing get interrupt vector functions\n");
    __dos32_get_protect_mode_int_vec(14,&farptr);
    printf("  actual vector of int 14 (page fault) cs:eip - %04x:%08lx\n",
            farptr.selector,farptr.offset);
    __dos32_get_true_protect_mode_int_vec(14,&farptr);
    printf("  original pm vector of int 14 (page fault) cs:eip - %04x:%08lx\n",
            farptr.selector,farptr.offset);
    printf("testing dos int call via <dos.h>\n  printing char `X' via int 0x10 : ");
    fflush(stdout); /* make sure that all text up to this point is output */
    r.h.ah=0x0a;    /* func 0x0a */
    r.h.al='X';     /* char */
    r.w.cx=1;       /* once */
    r.h.bh=0;       /* page 0 */
    r.h.bl=7;       /* color gray */
    int86(0x10,&r,&r);
    printf("\n");
    printf("testing DMA functions\n  get DMA buffer ");
    if (__dos32_get_dma_buffer(&along,&mallocvar)) printf("failed\n");
    else {
        printf("success, phys. addr: %08lx offset: %08p\n",along,mallocvar);
        printf("  free DMA buffer ");
        if (__dos32_free_dma_buffer()) printf("failed\n");
        else printf("success\n");
    }
    printf("startup dma buffers %d\n",_crt0_alloc_dma);
    for(i=0;i<_crt0_alloc_dma;i++) {
      printf("  dma buffer %d: phys - %08lx ofs - %08p\n",i+1,
      __dos32_prealloced_dma[i].physical,__dos32_prealloced_dma[i].logical);
     }
    fprintf(stderr,"\n######## ALL TESTS FINISHED ########\n");
}


void fail_func(char *msg,int line)
{
    printf("*** TEST OF %s FAILED AT LINE %d ! ***\n",msg,line);
    exit(1);
}
