/* header file for accessing dos32 functions */
#ifndef __cl_include_dos32api_h_
#define __cl_include_dos32api_h_


#ifdef __cplusplus
extern "C" {
#endif

#include <sys/cltypes.h>

/* vars from crt0 */

extern unsigned long __dos32_prog_base;
extern unsigned long __exe_length;
extern _cl_flatptr   __psp_address;
extern _cl_flatptr   __env_address;
extern _cl_flatptr   __dos32_dos_buffer;
extern unsigned short __dos32_version;
extern _cl_selector  __dos32_ds;
extern _cl_selector  __dos32_cs;
extern _cl_selector  __dos32_zero;
extern _cl_segment   __dos32_dos_buffer_seg;
extern unsigned char __dos32_system;
extern _cl_flatptr   __vga_video_mem;
extern _cl_flatptr   __primary_screen_address;
extern _cl_flatptr   __secondary_screen_address;

typedef struct {
unsigned long physical;
_cl_flatptr   logical;
} __dma_address_info;

/* maximum 8 dma channels */
extern __dma_address_info __dos32_prealloced_dma[8];

#define __DOS32_DTA ((char *)__psp_address+0x80)
#define DOS32_SYSTEM_RAW_DOS 1
#define DOS32_SYSTEM_XMS     2
#define DOS32_SYSTEM_VCPI    4
#define DOS32_SYSTEM_DPMI    8

/* types for the API */

typedef struct {
unsigned long    edi,esi,ebp,reserved,ebx,edx,ecx,eax;
unsigned short   flags,es,ds,fs,gs,ip,cs,sp,ss;
} _dos32_regs;

/* stuff for dll loading */
#define DOS32_DLL_NO_MEM     -1
#define DOS32_DLL_FILE_ERROR -2
#define DOS32_DLL_BAD_DLL    -3
#define DOS32_DLL_LOAD_ERROR -4


/******************************************************************************
 *  DOS32 API functions - much less than DPMI, but they should be sufficient  *
 *  for most applications (unless you do really weird things)                 *
 ******************************************************************************/

/* these functions return !=0 if they fail, 0 on success */
extern int __dos32_get_dma_buffer(unsigned long *physical_address,void **block_address);
extern int __dos32_free_dma_buffer(void);
extern int __dos32_call_realmode_int(unsigned char number,_dos32_regs *regs,char flags);
extern int __dos32_call_realmode_proc_retf(_dos32_regs *regs,char flags);
extern int __dos32_call_realmode_proc_iret(_dos32_regs *regs,char flags);

/* these function can't fail */
extern void __dos32_set_protect_mode_int_vec(char number,_cl_farptr *vector);
extern void __dos32_get_protect_mode_int_vec(char number,_cl_farptr *vector);
/*
   returns 1, if the startup code has installed a different handler,
   otherwise 0
   BEWARE: this is only for chaining down to an old handler, if you want
   the actual handler call the function above
*/
int __dos32_get_true_protect_mode_int_vec(char number,_cl_farptr *vector);

/* these functions return 0 if they fail, otherwise an address */
extern _cl_flatptr __dos32_set_physical_memory_mapping(unsigned long physical,unsigned long size);
extern long __dos32_get_iret_call_back(_cl_flatptr address);
extern long __dos32_get_retf_call_back(_cl_flatptr address);

/* macros for converting real mode adresses to flat */
#define __real2linear(a) ((((a) & 0xffff0000U) >> 12)+((a) & 0xffffU))
#define __real2flat(a)   (void *)(__real2linear(a)-__dos32_prog_base)
#define __seg2linear(a)  ((a)<<4)
#define __seg2flat(a)    (void *)(__seg2linear(a)-__dos32_prog_base)

/* this is the only function which remains of dpmi.h */
void __dpmi_yield(void);

/* cbreak handling */
#define DOS32_CBREAK_IGNORE 1
#define DOS32_CBREAK_COUNT  2

void __dos32_set_cbreak_mode(char mode);
int  __dos32_cbreak_hit(void);

/*
  dll load function, for error return values see the DOS32_DLL macros, they're
  quite self explaining
  values>0 -> size of dll loaded
*/
long __dos32_load_dll(const char *name,const unsigned long dll_pos,
                      void **entry_point,void **dll_start);

#ifdef __cplusplus
}
#endif

#else
#endif

