
;ͻ
;                                                                          
; EOS.INC (Tabs : 13 21 29 37)                                             
;                                                                          
;ͼ

;ͻ
;                                                                          
; EOS Variables                                                            
;                                                                          
;ͼ


;
; MASM Declarations
;

IFNDEF  ??version
     Global EQU  Externdef
ENDIF

;
; Versions
;

Ver_EOS             equ db '3.03'
Ver_Diamond         equ db '3.03'
Ver_Vesa            equ db '3.03'
Ver_Fli32           equ db '3.03'
Ver_Debug           equ db '3.03'
Ver_Snap            equ db '3.03'
Ver_Joystick        equ db '3.03'
Ver_Edconfig        equ db '3.03'
Ver_Memory          equ db '3.03'
Ver_Serial          equ db '3.03'
Ver_Gif             equ db '3.03'
Ver_CDROM           equ db '3.03'


;
; Key_Map (Azerty)
;

All         = 0
Escape      = 1
Return      = 28
Alt         = 56
Space       = 57
Left        = 75
Right       = 77
Up          = 72
Down        = 80
Plus        = 78
Moins       = 74
Ctrl        = 29
Num_1       = 79
Num_2       = 80
Num_3       = 81
Num_4       = 75
Num_5       = 76
Num_6       = 77
Num_7       = 71
Num_8       = 72
Num_9       = 73
Num_0       = 82
Key_1       = 02
Key_2       = 03
Key_3       = 04
Key_4       = 05
Key_5       = 06
Key_6       = 07
Key_7       = 08
Key_8       = 09
Key_9       = 10
Key_0       = 11
Key_A       = 16
Key_Z       = 17
Key_E       = 18
Key_R       = 19
Key_T       = 20
Key_Y       = 21
Key_U       = 22
Key_I       = 23
Key_O       = 24
Key_P       = 25
Key_Q       = 30
Key_S       = 31
Key_D       = 32
Key_F       = 33
Key_G       = 34
Key_H       = 35
Key_J       = 36
Key_K       = 37
Key_L       = 38
Key_M       = 39
Key_W       = 44
Key_X       = 45
Key_C       = 46
Key_V       = 47
Key_B       = 48
Key_N       = 49
Key_F1      = 59
Key_F2      = 60
Key_F3      = 61
Key_F4      = 62
Key_F5      = 63
Key_F6      = 64
Key_F7      = 65
Key_F8      = 66
Key_F9      = 67
Key_F10     = 68
Key_F11     = 87
Key_F12     = 88

;
; Others
;

Impossible  = 0     ; For the cut and paste (Ever 0)

On          = 1
Off         = 0

vbl         = On

Int_Val_EOS = 61h
Int_EOS     Equ Int Int_Val_EOS

B Equ Byte Ptr
W Equ Word Ptr
D Equ Dword Ptr
F Equ Fword Ptr
O Equ Offset

RAW         equ 01h
XMS         equ 02h
VCPI        equ 04h
DPMI        equ 08h


;ͻ
;                                                                          
; EOS Macros                                                               
;                                                                          
;ͼ


Border      macro color
            if vbl
	push eax edx
            mov dx,03dah
            in al,dx
            nop
            nop
            nop
            mov dx,03c0h
            mov al,11h+32
            out dx,al
            mov al,color
            out dx,al
	pop edx eax
            endif
            endm

Color       macro c,x,y,z
            if vbl
            pushfd
            push edx
            push eax
	mov dx,3c8h
            mov al,c
	out dx,al
	inc dx
            mov al,x
	out dx,al
            mov al,y
	out dx,al
            mov al,z
	out dx,al
            pop eax
            pop edx
            popfd
            endif
	endm

Send        macro value,x,y
            pushad
            pushfd
            mov edx,value
            mov bx,x
            mov cx,y
            mov ah,Set_Value_Mono
            Int_EOS
            popfd
            popad
            endm

Get_Param   macro name
local @@no_path
local @@end
            mov esi,cs:[Psp_Addr]
            add esi,80h
            mov cl,byte ptr [esi]
            and ecx,0ffh
            mov byte ptr [esi],0
            je @@no_path
            lea edi,name
            add esi,2
            rep movsb
            mov Byte ptr es:[edi-1],0
            clc
            jmp @@end
@@no_path:
            stc
@@end:
            endm

Break_Point macro
            int 3
            endm


;ͻ
;                                                                          
; EOS Functions                                                            
;                                                                          
;ͼ


;ͻ
;                                                                          
;                                System                                    
;                                                                          
;ͼ


;Ŀ
;Exit Error   Restore initial Video mode , interrupts , free all reserved  
;             memory ,stop music if played and exit (with error code 1)    
;             with a error message                                         
;                                                                          
;In :                                                                      
;        AH = Exit_Error                                                   
;    DS:EDX = Offset message to display                                    
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Exit_Error = 1h
If Impossible
            mov ah,Exit_Error
            mov edx,Offset Error_Txt
            Int_EOS
EndIf


;Ŀ
;Use Int 08   Use Int 08 (IRQ 0) to count frame rate and have a stable     
;             vertical retrace                                             
;             Defaults frequency is 70Hz                                   
;                                                                          
;In :                                                                      
;        AH = Use_Int_08                                                   
;        BX = On Enable Int 08                                             
;           = Off Disable Int 08                                           
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Use_Int_08          = 02h
If Impossible
            mov ah,Use_Int_08
            mov bx,On
            Int_EOS
EndIf


;Ŀ
;Change Synchro Int 08   Change frequency for Interupt 08                  
;                        Defaults frequency is 70Hz                        
;                                                                          
;In :                                                                      
;        BX = frequency                                                    
;        AH = Change_Synchro_Int_08                                        
;                                                                          
;Out :                                                                     
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Change_Synchro_Int_08      = 03h
If Impossible
            mov bx,70                   ; 70hz
            mov ah,Change_Synchro_Int_08
            Int_EOS
EndIf


;Ŀ
;Use Int 09   Use Internal Keyboard handler to use keyboard                
;                                                                          
;In :                                                                      
;        AH = Use_Int_09                                                   
;        BX = On Enable Int 09                                             
;           = Off Disable Int 09 (Default setting)                         
;                                                                          
;                                                                          
;Out :                                                                     
;      EAX = Physical address of the key_map array (for watcom users)      
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;

Global Key_Map      : Byte  ; Offset of the Key_Mapping

Use_Int_09          = 04h
If Impossible
            mov ah,Use_Int_09
            mov bx,On
            Int_EOS

            ...

@@Pause:                            ; Test if key pressed
            cmp Key_Map[All],Off
            je @@Pause
            mov Key_Map[All],Off

            ...

@@Pause:                            ; Test if the Esc key is pressed
            cmp Key_Map[Escape],On  ; Actually
            jne @@Pause

            ...

@@Pause:                            ; Test if the ESC key have been pressed
            cmp Key_Map[All],Escape
            jne @@Pause
EndIf


;Ŀ
;Restore Video Mode   Restore the inital video which is be active at the   
;                     start of the program                                 
;                                                                          
;In :                                                                      
;        AH = Restore_Video_Mode                                           
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Restore_Video_Mode  = 07h
If Impossible
            mov ah,Restore_Video_Mode
            Int_EOS
EndIF

;Ŀ
;Detect Windows       Detect If Windows is running                         
;                                                                          
;In :                                                                      
;        AH = Detect_Windows                                               
;                                                                          
;Out :                                                                     
;        AL = Windows version                                              
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Detect_Windows      = 0Ah
Windows_3x          = 3
Windows_95          = 4
If Impossible
            lea edx,Windows_Txt
            mov ah,Detect_Windows
            Int_EOS
            or al,al
            jnz Error

            ...

Windows_Txt         db "     Sorry, but this program can not run under Microsoft Windows (tm)",13,10,36
EndIF

;Ŀ
;Direct Send          Write a text directly to video ram . Color allowed   
;                                                                          
;In :                                                                      
;        AH = Direct_Send                                                  
;       EDX = Offset message to Display                                    
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;Command : 0,0      = end                                                  
;          0,1..255 = color                                                
;          13       = first colonne                                        
;          10       = next ligne                                           
;                                                                          
;
Direct_Send         = 0Eh
If Impossible
            lea edx,Message
            mov ah,Direct_Send
            Int_EOS

            ...

Message             db "    ",0,1," Color Blue ",0,4,"Red ",13,10,0,0
EndIF


;ͻ
;                                                                          
;                                 Files                                    
;                                                                          
;ͼ


;Ŀ
;Load Internal File   Load a file which is link with LLINK                 
;                     if the file is not present the program stop and      
;                     display a error message                              
;                                                                          
;In :                                                                      
;        AH = Load_Internal_File                                           
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       EAX = Logical address of buffer (work with Data32_Sel)             
;       ECX = Number of bytes read                                         
;       ESI = Physical address of buffer (work with Flat_Data_Sel)         
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_Internal_File  = 10h
If Impossible
            mov ah,Load_Internal_File
            mov edx,O File_name
            Int_EOS
            mov [File_Buffer],eax
EndIf


;Ŀ
;Load External File   Load a external file and uncompress it if it has     
;                     been compress with Diet 1.44                         
;                                                                          
;In :                                                                      
;        AH = Load_External_File                                           
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = Logical address of buffer (work with Data32_Sel)             
;       ECX = Number of bytes read                                         
;       ESI = Physical address of buffer (work with Flat_Data_Sel)         
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 File Not Found                                             
;             2 Not Enough Memory                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_External_File  = 11h
If Impossible
            mov ah,Load_External_File
            mov edx,O File_name
            Int_EOS
            jc Error_File
            mov [File_Buffer],eax
EndIf


;Ŀ
;Load Internal File Handle  Load a file which is link with LLINK           
;                           if the file is not present the program stop and
;                           display a error message                        
;                                                                          
;In :                                                                      
;        AH = Load_Internal_File_Handle                                    
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       EAX = Logical address of buffer (work with Data32_Sel)             
;       ECX = Number of bytes read                                         
;       ESI = Physical address of buffer (work with Flat_Data_Sel)         
;       EDI = Handle of Memory                                             
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_Internal_File_Handle  = 12h
If Impossible
            mov ah,Load_Internal_File_Handle
            mov edx,O File_name
            Int_EOS
            mov [File_Buffer],eax
            mov [Handle_Memory],edi
EndIf


;Ŀ
;Load External File Handle  Load a external file and uncompress it if it   
;                           has been compress with Diet 1.44               
;                                                                          
;In :                                                                      
;        AH = Load_External_File_Handle                                    
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = Logical address of buffer (work with Data32_Sel)             
;       ECX = Number of bytes read                                         
;       ESI = Physical address of buffer (work with Flat_Data_Sel)         
;       EDI = Handle of Memory                                             
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 File Not Found                                             
;             2 Not Enough Memory                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_External_File_Handle  = 13h
If Impossible
            mov ah,Load_External_File_Handle
            mov edx,O File_name
            Int_EOS
            jc Error_File
            mov [File_Buffer],eax
            mov [Handle_Memory],edi
EndIf


;Ŀ
;Write External File  Save a File on a Disk                                
;                                                                          
;Entree :                                                                  
;        AH = Write_External_File                                          
;       ECX = Size Of File                                                 
;       EDX = Offset of file name                                          
;       ESI = Buffer address                                               
;                                                                          
;Sortie :                                                                  
;       Carry = 0                                                          
;        Tout Va Bien                                                      
;                                                                          
;       Carry = 1                                                          
;        Erreur  Can't write file                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Write_External_File  = 14h
If Impossible
            mov ah,Write_External_File
            mov edx,O File_name
            mov esi,[Buffer]
            mov ecx,[Size_Buffer]
            Int_EOS
            jc Error_File
EndIf


;ͻ
;                                                                          
;                              Synchronization                             
;                                                                          
;ͼ


;
; Synchronization Declaration
;

Global       Nb_Vbl                 : Dword

;Ŀ
;Wait Vbl   Wait the vertical retrace                                      
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       EAX = Number of Vbl lost since the last call                       
;             (work only when the Int 08 is on)                            
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Wait_Vbl            = 20h
If Impossible
            mov ah,Wait_Vbl
            Int_EOS
EndIf


;ͻ
;                                                                          
;                              Diamond Player                              
;                                                                          
;ͼ


;
; Diamond Player Declaration
;

  Global    Sound_Card_Type         : Byte
  Global    Sound_Card_Port         : Word
  Global    Sound_Card_Irq          : Byte
  Global    Sound_Card_Dma          : Byte
  Global    Master_Volume           : Byte
  Global    Master_Volume_Sfx       : Byte
  Global    Current_Pattern         : Byte
  Global    Current_Note            : Byte
  Global    Current_Speed           : Byte
  Global    Current_BPM             : Byte
  Global    Index_Pattern_Order     : Dword
  Global    Pattern_Order           : Byte
  Global    Number_Channel          : Dword
  Global    Diamond_Channel         : MS


  No_Card    = 0
  Sb_10      = 01h
  Sb_15      = 02h
  Sb_20      = 03h
  Sb_Pro     = 04h
  Sb_16      = 05h
  Sb_Awe     = 06h
  Gravis     = 10h
  Gravis_Max = 11h
  Gravis_Ace = 12h
  Gravis_Pnp = 13h
  WSS        = 20h

MS                  struc
Current_Sample      dd      0
Porta               dw      ?
Tremelo             db      ?
Current_Position    dd      ?
Current_Low_Position dd     ?               ; Low Frac of the Current Position
Jump_0e6            db      ?
Compt_jump_0e6      db      ?
Flags_0e6           db      ?
Porta_Freq          dw      ?
Porta_To            dw      ?
Vibrato             db      ?
Vibrato_Flag        db      ?
FineTune            dw      ?
Last_Effect         dd      0
Voice               db      ?               ; Soit 1 ou 16 Soit 2 ou 17 etc ....
Sample_volume       db      ?
Base_Sample_Volume  db      ?
Mute                db      ?               ; On Arrete la voie
Frequence           dw      ?
Compt_Frequence     dd      ?
New_sample          db      ?
Arp                 dw      ?,?,?
Arp_Counter         dw      ?
Slide_volume        dw      ?
Panning             db      ?
Retrig_Note         db      ?
Retrig_Note_Val     db      ?
Cut_Note            db      ?
Delay_Note          db      ?
                    db      0
Delay_Note_Offset   dd      ?
Addr_Read_Again     dd      ?               ; Addresse pour la routine Delay
MS                  ends

;Ŀ
;Detect Sound Card   Detect with the environment variable the sound        
;                    card installed                                        
;                                                                          
;In :                                                                      
;        AH = Detect_Sound_Card                                            
;        CX = 1  Display result of Searching                               
;                                                                          
;Out :                                                                     
;        AX = 0  No_Card                                                   
;           = 1  Sound Blaster 1.0                                         
;           = 2  Sound Blaster 1.5                                         
;           = 3  Sound Blaster 2.0                                         
;           = 4  Sound Blaster Pro                                         
;           = 5  Sound Blaster 16                                          
;           = 6  Sound Blaster Awe 32                                      
;           = 10h  Gus                                                     
;           = 11h  Gus Max                                                 
;           = 12h  Gus Ace                                                 
;           = 13h  Gus Pnp                                                 
;           = 20h  WSS                                                     
;        BX = Port                                                         
;        CX = Irq                                                          
;        DX = Dma                                                          
;        SI = Dsp Version (For Sb) ou                                      
;             Size of RAM of the Gravis                                    
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Detect_Sound_Card   = 30h
If Impossible
            mov ah,Detect_Sound_Card
            mov cx,1
            Int_EOS
EndIf


;Ŀ
;Load Module   Load a module & initialize into the memory                  
;                                                                          
;In :                                                                      
;        AH = Load_Module                                                  
;        AL = Bit 0 = 1  Load a internal module (can be compress and link  
;                        with LLINK)                                       
;           = Bit 1 = 1  Load module  from memory                          
;           = Bit 2 = 1  Force old mod Loading (15 instr)                  
;        BX = Replay rate (16000 to 44100 Hz)                              
;        CX = Number of Sfx Channel                                        
;        DS:EDX = Offset of Module name or                                 
;                 Offset into the memory of the beginning of the module    
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Can't Load Module                                            
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_Module         = 32h
If Impossible
            mov ah,Load_Module
            mov al,4+1
            mov bx,22000
            xor ecx,ecx
            mov edx,O Module_Name
            Int_EOS
            jc Error_Loading_Module
EndIf


;Ŀ
;Play Module   Start playing the module                                    
;                                                                          
;In :                                                                      
;        AH = Play_Module                                                  
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Can't Play Module                                            
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Play_Module         = 34h
If Impossible
            mov ah,Play_Module
            Int_EOS
EndIf


;Ŀ
;Stop Module   Stop playing module                                         
;                                                                          
;In :                                                                      
;        AH = Stop_Module                                                  
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Stop_Module         = 35h
If Impossible
            mov ah,Stop_Module
            Int_EOS
EndIf


;Ŀ
;Clear Module   Unload the module from memory                              
;                                                                          
;In :                                                                      
;        AH = Clear_Module                                                 
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Clear_Module        = 36h
If Impossible
            mov ah,Clear_Module
            Int_EOS
EndIf


;Ŀ
;Manual Setup Sound Card                                                   
;                                                                          
;In :                                                                      
;        AH = Manual_Setup                                                 
;        AL = Type                                                         
;        BX = Port                                                         
;        CL = Irq1                                                         
;        CH = Irq2      ; Irq Gus 2                                        
;        DL = Dma1      ; Dma Gus 1 or Dma 8 Bits for SB                   
;        DH = Dma2      ; Dma Gus 2 or Dma 16 Bits for SB                  
;                                                                          
;Out :                                                                     
;        Carry Off                                                         
;        Init Ok                                                           
;                                                                          
;        Carry On                                                          
;        No Sound Card Found                                               
;                                                                          
;
Manual_Setup        = 37h
If Impossible
            mov ah,Manual_Setup
            mov al,Gravis
            mov bx,220h
            mov cl,7
            mov ch,7
            mov dl,1
            mov dh,1
            Int_EOS
            ...
            mov ah,Manual_Setup
            mov al,Sb_16
            mov bx,220h
            mov cl,7
            mov dl,1
            mov dh,5
            Int_EOS
EndIf


;Ŀ
;Set Volume   Set the master volume of the module                          
;                                                                          
;In :                                                                      
;        AH = Set_Volume                                                   
;        BL = Volume (0 to 63)                                             
;        CL = Sfx Volume (0 to 63)                                         
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Volume          = 3ah
If Impossible
            mov ah,Set_Volume
            mov bl,[New_Volume]
            mov cl,[New_Volume_Sfx]
            Int_EOS
EndIf


;Ŀ
;Play Sample   Play a sample include into the module                       
;                                                                          
;In :                                                                      
;        AH = Play_Sample                                                  
;        BX = Sample numbers                                               
;        CX = Sample Frequency                                             
;        DX = voice of sample                                              
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Play_Sample         = 3bh
If Impossible
            mov ah,Play_Sample
            mov bx,10
            mov cx,15fh
            mov dx,4
            Int_EOS
EndIf


;Ŀ
;Get Info   Get information about the module when playing                  
;                                                                          
;In:                                                                       
;        AH = Get_Info                                                     
;                                                                          
;Out:                                                                      
;        AH = Position                                                     
;        AL = Pattern                                                      
;        BX = Note                                                         
;        CL = Master Volume                                                
;        DL = Master Volume Sfx                                            
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Get_Info            = 3eh
If Impossible
            mov ah,Get_Info
            Int_EOS
EndIf


;Ŀ
;Set Pattern  Set the current position of the playing module               
;                                                                          
;In:                                                                       
;        AH = Set_Pattern                                                  
;        BX = New_Position                                                 
;        CX = New_Note                                                     
;                                                                          
;Out:                                                                      
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Pattern         = 3fh
If Impossible
            mov ah,Set_Pattern
            mov bx,[New_Position]
            mov cx,[New_Note]
            Int_EOS
EndIf


;ͻ
;                                                                          
;                     Interrupt & Irq Functions                            
;                                                                          
;ͼ


;Ŀ
;Get_Int       Get protected mode interrupt vector                         
;                                                                          
;In :                                                                      
;        AH = Get_Int                                                      
;        BX = Interrupt number                                             
;                                                                          
;Out :                                                                     
;    CX:EDX = Selector:Offset of interrupt                                 
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Get_Int             = 50h
If Impossible
            mov ah,Get_Int
            mov bx,10h
            Int_EOS
            mov [Old_Int_10_Selector],cx
            mov [Old_Int_10_Offset],edx
EndIf


;Ŀ
;Set_Int       Set protected mode interrupt vector                         
;                                                                          
;In :                                                                      
;        AH = Get_Int                                                      
;        BX = Interrupt number                                             
;    CX:EDX = Selector:Offset of interrupt                                 
;                                                                          
;Out :                                                                     
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Set_Int             = 51h
If Impossible
            mov ah,Set_Int
            mov bx,10h
            mov cx,cs
            mov edx,O New_Int_10
            Int_EOS
EndIf


;Ŀ
;Get_Irq       Get protected mode irq vector                               
;                                                                          
;In :                                                                      
;        AH = Get_Irq                                                      
;        BX = Irq number                                                   
;                                                                          
;Out :                                                                     
;    CX:EDX = Selector:Offset of irq                                       
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Get_Irq             = 52h
If Impossible
            mov ah,Get_Irq
            mov bx,1h                               ; Keyboard
            Int_EOS
            mov [Old_Irq_01_Selector],cx
            mov [Old_Irq_01_Offset],edx
EndIf


;Ŀ
;Set_Irq       Set protected mode irq vector                               
;                                                                          
;In :                                                                      
;        AH = Get_Irq                                                      
;        BX = Irq number                                                   
;    CX:EDX = Selector:Offset of irq                                       
;                                                                          
;Out :                                                                     
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Set_Irq             = 53h
If Impossible
            mov ah,Set_Irq
            mov bx,1h                               ; Keybord
            mov cx,cs
            mov edx,O New_Irq_01
            Int_EOS
EndIf


;ͻ
;                                                                          
;                           Memory Allocation                              
;                                                                          
;ͼ


;Ŀ
;Allocate Memory   Allocate Upper memory                                   
;                                                                          
;In :                                                                      
;        AH = Allocate_Memory                                              
;       EDX = Size of memory block to allocate in bytes                    
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       EAX = Physical address of the block (work with Flat_Data_Sel)      
;       EDX = Logical address of the block (work with Data32_Sel)          
;                                                                          
;        Carry = 1                                                         
;             Can't allocate memory                                        
;       EAX = Largest available free memory                                
;       EDX = Total available memory                                       
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Allocate_Memory   = 40h
If Impossible
            mov ah,Allocate_Memory
            mov edx,[Allocation_Size]
            Int_EOS
            jc Not_Enough_Memory
            mov [Physical_Address_Of_Block],eax     ; Work with Flat_Data_Sel
            mov [Logical_Address_Of_Block],edx      ; Work with Data32_Sel
EndIf


;Ŀ
;DeAllocate Memory   Free the last allocate memory                         
;                                                                          
;In :                                                                      
;        AH = DeAllocate_Memory                                            
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
DeAllocate_Memory = 41h
If Impossible
            mov ah,DeAllocate_Memory
            Int_EOS
EndIf

;Ŀ
;Allocate Memory Handle  Allocate Upper memory with handle                 
;                                                                          
;In :                                                                      
;        AH = Allocate_Memory                                              
;       EDX = Size of memory block to allocate in bytes                    
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       EAX = Physical address of the block (work with Flat_Data_Sel)      
;       EDX = Logical address of the block (work with Data32_Sel)          
;       EDI = Handle of Memory                                             
;                                                                          
;        Carry = 1                                                         
;             Can't allocate memory                                        
;       EAX = Largest available free memory                                
;       EDX = Total available memory                                       
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Allocate_Memory_Handle = 42h
If Impossible
            mov ah,Allocate_Memory_Handle
            mov edx,[Allocation_Size]
            Int_EOS
            jc Not_Enough_Memory
            mov [Physical_Address_Of_Block],eax     ; Work with Flat_Data_Sel
            mov [Logical_Address_Of_Block],edx      ; Work with Data32_Sel
            mov [Memory_Handle],edi
EndIf


;Ŀ
;DeAllocate Memory Handle  Free the allocate memory with this handle       
;                                                                          
;In :                                                                      
;        AH = DeAllocate_Memory                                            
;       EDI = Handle of Memory                                             
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Invalid handle                                               
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
DeAllocate_Memory_Handle = 43h
If Impossible
            mov ah,DeAllocate_Memory_Handle
            mov edi,[Memory_Handle]
            Int_EOS
            jc Invalid_Handle
EndIf

;Ŀ
;Resize Memory Handle    Resize the allocate memory with this handle       
;                                                                          
;In :                                                                      
;        AH = Resize_Memory_Handle                                         
;       ECX = New Size of the memory block                                 
;       EDI = Handle of Memory                                             
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       EAX = Physical address of the block (work with Flat_Data_Sel)      
;       EDX = Logical address of the block (work with Data32_Sel)          
;       EDI = New Handle of Memory                                         
;                                                                          
;        Carry = 1                                                         
;             Invalid handle                                               
;             Not Enough Memory                                            
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Resize_Memory_Handle = 44h
If Impossible
            mov ah,Resize_Memory_Handle
            mov edi,[Memory_Handle]
            Int_EOS
            jc Invalid_Handle
            mov [Memory_Handle],edi
            mov [Addr_Memory],edx
EndIf


;Ŀ
;Allocate Selector   Create a new selector (Data type)                     
;                                                                          
;In :                                                                      
;        AH = Allocate_Selector                                            
;       ESI = Physical base address of the new selector                    
;       EDI = Size of the new selector modulo 4096                         
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;        BX = New selector                                                 
;                                                                          
;        Carry = 1                                                         
;             Can't create selector                                        
;                                                                          
;Other Registers Change : EAX                                              
;                                                                          
;                                                                          
;
Allocate_Selector   = 45h
If Impossible
            mov ah,Allocate_Selector
            mov esi,0a0000h
            mov edi,0fh         ; 64ko (0000-ffff)
            Int_EOS
            jc No_Free Selector
            mov [_0a0000h_Sel],bx
EndIf


;Ŀ
;DeAllocate Selector   Free a Selector                                     
;                                                                          
;In :                                                                      
;        AH = DeAllocate_Selector                                          
;        BX = Selector                                                     
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Can't deallocate selector                                    
;                                                                          
;Other Registers Change :  EAX,EBX                                         
;                                                                          
;                                                                          
;
DeAllocate_Selector = 46h
If Impossible
            mov ah,DeAllocate_Selector
            mov bx,[_0a0000h_Sel]
            Int_EOS
            jc Invalid_Selector
EndIf


;Ŀ
;Physical Address Mapping                                                  
;                                                                          
;In :                                                                      
;        AH = Physical_Address_Mapping                                     
;       ECX = Size Of region                                               
;       ESI = Physical address of memory                                   
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;       ESI = Linear Address of the region                                 
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             No Room free                                                 
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Physical_Address_Mapping = 47h
If Impossible
            mov ah,Physical_Address_Mapping
            mov ecx,1024*1024
            mov esi,[Vesa_Linear_Address]
            Int_EOS
            jc Not_Enough_Memory
EndIf


;Ŀ
;Free Physical Address Mapping      Free the allocate memory mapping       
;                                                                          
;In :                                                                      
;        AH = Free_Address_Mapping                                         
;       ESI = Address of the block to free                                 
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Invalid address                                              
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Free_Physical_Address_Mapping = 48h
If Impossible
            mov ah,Free_Physical_Address_Mapping
            mov esi,[Vesa_Linear_Address]
            Int_EOS
            jc Invalid_Address
EndIf




;ͻ
;                                                                          
;                      Monochrome Display                                  
;                                                                          
;ͼ


;Ŀ
;Set Mono   Force On/Off the display of all the Monochrome Function        
;                                                                          
;In :                                                                      
;        AH = Set_Mono                                                     
;        BX = On  Force Monochrome Off                                     
;             Off Force Monochrome On                                      
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Mono            = 0e0h
If Impossible
            mov ah,Set_Mono
            mov bx,On
            Int_EOS
EndIf


;Ŀ
;Set String Mono   Display a string on the Monochrome adapter              
;                                                                          
;In :                                                                      
;        AH = Set_String_Mono                                              
;        BX = Coordonate  X                                                
;        CX = Coordonate  Y                                                
;       EDX = Address of text ending by $                                  
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_String_Mono     = 0e1h
If Impossible
            mov ah,Set_String_Mono
            mov bx,1
            mov cx,10
            mov edx,offset text_mono
            Int_EOS
EndIf


;Ŀ
;Set Value Mono   Display A Word in Hexadecimal on the Monochrome adapter  
;                                                                          
;In :                                                                      
;        AH = Set_Value_Mono                                               
;        BX = Coordonate X                                                 
;        CX = Coordonate Y                                                 
;        EDX = Value to be display                                         
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Value_Mono      = 0e2h
If Impossible
            mov ah,Set_Value_Mono
            mov bx,1
            mov cx,10
            mov dx,1234h
            Int_EOS
EndIf


;ͻ
;                                                                          
; EOS Library                                                              
;                                                                          
;ͼ


;ͻ
;                                                                          
; VESA                                                                     
;                                                                          
;ͼ

Global Init_Vesa            : Proc
Global Init_Vesa2           : Proc
Global Set_Bank             : Proc
Global Next_Bank            : Proc
Global Vesa_Current_Bank    : Byte

Global Init_Vesa_Bank       : Proc
Global Close_Vesa_Bank      : Proc

Global Vesa_Clear_Palette   : Byte

; ------------ VBE v1.0  ------------------
Mode640x400x256             = 100h
Mode640x480x256             = 101h
Mode800x600x16              = 102h
Mode800x600x256             = 103h
Mode1024x768x16             = 104h
Mode1024x768x256            = 105h
Mode1280x1024x16            = 106h
Mode1280x1024x256           = 107h
Mode80x60                   = 108h
Mode132x25                  = 109h
Mode132x43                  = 10ah
Mode132x50                  = 10bh
Mode132x60                  = 10ch
; ------------ VBE v1.2+ ------------------
Mode320x200x32k             = 10dh
Mode320x200x64k             = 10eh
Mode320x200x16M             = 10fh
Mode640x480x32k             = 110h
Mode640x480x64k             = 111h
Mode640x480x16M             = 112h
Mode800x600x32k             = 113h
Mode800x600x64k             = 114h
Mode800x600x16M             = 115h
Mode1024x768x32k            = 116h
Mode1024x768x64k            = 117h
Mode1024x768x16M            = 118h
Mode1280x1024x32k           = 119h
Mode1280x1024x64k           = 11ah
Mode1280x1024x16M           = 11bh

;Ŀ
;Init Vesa   Initialize A Vesa 1.x or 2.0 to use automatic bank switching  
;                                                                          
;In :                                                                      
;        EAX = Vesa mode                                                   
;                                                                          
;Out :                                                                     
;        EAX = VRAM address                                                
;                                                                          
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Mode Vesa not supported or Vesa driver not found             
;                                                                          
;
If Impossible
            mov eax,Mode640x480x256
            call Init_Vesa
            jc Error_Vesa

            ...

Vesa_Txt            db '     Mode SVGA not supported or VESA not found !',13,10
                    db '      To install a vesa driver, refer to your video card documentation.',13,10,36
EndIf


;Ŀ
;Init Vesa2  Initialize A Vesa 2.0 to use linear frame buffer              
;                                                                          
;In :                                                                      
;        EAX = Vesa mode                                                   
;        ECX = Video buffer size                                           
;                                                                          
;Out :                                                                     
;        EAX = Linear buffer address                                       
;                                                                          
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Mode Vesa not supported or Vesa driver not found             
;                                                                          
;
If Impossible
            mov eax,Mode640x480x256
            mov ecx,640*480
            call Init_Vesa2
            jc Error_Vesa
            mov [Screen],eax

            ...

Vesa_Txt            db '     Mode SVGA not supported or VESA not found !',13,10
                    db '      To install a vesa driver, refer to your video card documentation.',13,10,36
EndIf


;Ŀ
;Init Vesa Bank  Init the Automatic Bank Switching                         
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       BX = New selector for addressing the video ram                     
;                                                                          
;        Carry = 1                                                         
;             Can't allocate selector                                      
;                                                                          
;
If Impossible
            call Init_Vesa_Bank
            jc Error_Sel
            mov [screen_selector],bx

            ...

            mov edx,edi     ; EDI Address of first pixel to be display
            shr edx,16
            call Set_Bank
            and edi,0ffffh

            ...

            call Close_Vesa_Bank
EndIf

;Ŀ
;Set Bank        Set the Current Bank                                      
;                                                                          
;In :                                                                      
;      EDX = New Bank                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            mov edx,1
            call Set_Bank
EndIf


;ͻ
;                                                                          
; FLI32                                                                    
;                                                                          
;ͼ

Global Load_Fli             : Proc
Global Load_Internal_Fli    : Proc
Global Dispose_Fli          : Proc

Global First_Frame_Fli      : Proc
Global Next_Frame_Fli       : Proc

Global Fli_Err              : Byte
Global Fli_Svga             : Byte
Global Fli_Swap             : Byte

Global Fli_ReStart          : Byte
Global Fli_Loop             : Byte
Global Fli_TrackDisk        : Byte
Global Fli_Last_Frame       : Byte

Global Fli_Delay            : Dword
Global Fli_Buffer           : Dword

Global Fli_Ligne_Shl        : Byte
Global Fli_Scr_X            : Dword
Global Fli_Scr_Y            : Dword
Global Fli_Decal_Y          : Dword
Global Fli_Decal_X          : Dword

Global Fli_Selector         : Word

Global Fli_Current_Frame    : Dword

;Ŀ
;Play a FLI/FLC files                                                      
;                                                                          
;Functions :                                                               
;                                                                          
;        Load_Fli          Load a FLI into the memory                      
;                          Initialize if needed the track-disk mode        
;                          check the header                                
;                                                                          
;        Load_Internal_Fli Load a FLI which is link with LLINK             
;                          check the header                                
;                                                                          
;        First_Frame_Fli   Uncompress the first frame                      
;                                                                          
;        Next_Frame_Fli    Uncompress next frame                           
;                                                                          
;        Dispose_Fli       Freeing memory                                  
;                          Close File                                      
;                                                                          
;Information During playing :                                              
;                                                                          
;        Fli_Err       = 1 - Chunk not found                               
;                        2 - Out of memory                                 
;                        3 - File error                                    
;                        4 - Bad FLC header                                
;                        5 - Size max for FLC : 640x480                    
;                                                                          
;        Fli_Swap      = On - Track disk running - not enough memory to    
;                             load the file                                
;                        Off- File has been load into memory               
;                                                                          
;        Fli_Svga      = On - Number of Ligne >200                         
;                                                                          
;        Fli_Delay     = Fli speed                                         
;                                                                          
;        Fli_Last_Frame= On - Last frame (Mode No looping)                 
;                                                                          
;Commands :                                                                
;                                                                          
;        Fli_Selector  = Screen selector                                   
;                                                                          
;        Fli_ReStart   = On - Restart at the begining of the animation     
;                                                                          
;        Fli_Loop      = On - Restart the FLI at the end (Defaults)        
;                        Off- Stop at the end  (Mode No looping)           
;                                                                          
;        Fli_TrackDisk = On - Enable Track-Disk mode                       
;                        Off- Track-Disk not use execpt when the FLI can't 
;                             be load into the memory                      
;                                                                          
;        Fli_Buffer    = Logical address of FLI buffer                     
;                                                                          
;
If Impossible
           mov edx, offset Fli_Path
         call Load_Fli
        jc Fli_Error

            cmp Fli_Svga,On
            je  @@Init_Svga
            jne @@Init_Vga

            ...

            mov Fli_Selector,[screen_selector]

            call First_Frame_Fli
            jc Fli_Error

@@again:
            mov ah,Wait_Vbl
            Int_EOS

            call Next_Frame_Fli
            jc Fli_Error

            cmp Key_Map[Escape],On
            jne @@again
endif


;ͻ
;                                                                          
; SNAP                                                                     
;                                                                          
;ͼ

;Ŀ
;Snap        Grab a 256 Colors screen in Non-Mode and save it in IFF format
;            Scroll Lock to lunch it                                       
;

;Ŀ
;Init Snap   Initialize the screen grabber . (You can change the int 09    
;            function Use_Int_09 after this Init                           
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;

Global Init_Snap    : Proc


;Ŀ
;Snap IFF    Grab the current Screen from Video RAM                        
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;

Global Snap_Iff     : Proc


;Ŀ
;Save IFF    Save a buffer to IFF                                          
;                                                                          
;In :                                                                      
;        AX = Screen Size X                                                
;        BX = Screen Size Y                                                
;       EDX = Offset of File Name                                          
;       ESI = Address to save in IFF                                       
;                                                                          
;Out :                                                                     
;                                                                          
;

Global Save_Iff     : Proc


;ͻ
;                                                                          
; JOYSTICK                                                                 
;                                                                          
;ͼ

Analog_A            = 1h
Analog_B            = 2h
Lpt_A               = 10h
Lpt_B               = 20h

Lpt1                = 1h
Lpt2                = 2h
Lpt3                = 3h
Lpt4                = 4h

joy_                Struc
J_Type              db 0
J_Addr              dw 0
J_Value_X           dd 0
J_Value_Y           dd 0
J_Min_X             dd 0
J_Max_X             dd 0
J_Min_Y             dd 0
J_Max_Y             dd 0
J_Center_X          dd 0
J_Center_Y          dd 0
J_Calibrate_Left    dd 0
J_Calibrate_Right   dd 0
J_Calibrate_Up      dd 0
J_Calibrate_Down    dd 0
J_Current_Left      db 0
J_Current_Right     db 0
J_Current_Up        db 0
J_Current_Down      db 0
J_Fire_1            db 0
J_Fire_2            db 0
J_Fire_3            db 0
J_Fire_4            db 0
                    ends

Global joy1         : joy_
Global joy2         : joy_
Global joy3         : joy_
Global joy4         : joy_
Global joy5         : joy_
Global joy6         : joy_

;Ŀ
;Init_Joystick  Init all port en address                                   
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Init_Joystick   : Proc


;Ŀ
;Detect_Joystick  Find if an analogic joystick is plug in port 1 ,2 or     
;Both                                                                      
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       EAX = 1 A joystick is plug in port 1                               
;             2 A joystick is plug in port 2                               
;             3 2 joystick is plug in port 1 and 2                         
;                                                                          
;        Carry = 1                                                         
;             No Joystick                                                  
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Detect_Joystick : Proc


;Ŀ
;Add_Joystick   Add a new joystick to be use by the library                
;                                                                          
;In :                                                                      
;        AX = Type Of joystick                                             
;             Analog_A                                                     
;             Analog_B                                                     
;             Lpt_A                                                        
;             Lpt_B                                                        
;        BX = Address of port                                              
;           = 1 Lpt1                                                       
;           = 2 Lpt2                                                       
;           = 3 Lpt3                                                       
;           = 4 Lpt4                                                       
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       ESI = Address of structure of joystick                             
;                                                                          
;        Carry = 1                                                         
;             No Joystick Available                                        
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Add_Joystick    : Proc


;Ŀ
;Update_Joystick  Must be called often to update all structure of all      
;Joystick                                                                  
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      UpDate_Joystick : Proc


;Ŀ
;Sub_Joystick   Delete a Joystick create by Add_Joystick                   
;                                                                          
;In :                                                                      
;       ESI = Address of structure to be delete                            
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Structure not found                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Sub_Joystick : Proc


;Ŀ
;Upper_Left     Take Value For Upper Left Joystick's Coordonate            
;                                                                          
;In :                                                                      
;       ESI = Address of structure                                         
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             No Fire Press                                                
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Upper_Left      : Proc


;Ŀ
;Lower_Right    Take Value For Lower Right Joystick's Coordonate           
;                                                                          
;In :                                                                      
;       ESI = Address of structure                                         
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             No Fire Press                                                
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Lower_Right     : Proc


;Ŀ
;Center         Take Value For Center Joystick's Coordonate                
;                                                                          
;In :                                                                      
;       ESI = Address of structure                                         
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             No Fire Press                                                
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Center          : Proc


;ͻ
;                                                                          
; MEMORY                                                                   
;                                                                          
;ͼ


;Ŀ
;Init_Memory    Turn the display memory on                                 
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;

Global      Init_Memory     : Proc


;ͻ
;                                                                          
; RS232                                                                    
;                                                                          
;ͼ

Global      Serial_Open             : Proc
Global      Serial_Close            : Proc
Global      Serial_Read             : Proc
Global      Serial_Read_Block       : Proc
Global      Serial_Write            : Proc
Global      Serial_Write_Block      : Proc
Global      Serial_Clear_Buffer     : Proc
Global      Serial_Status           : Proc
Global      Serial_Set_Dtr          : Proc
Global      Serial_Reset_Dtr        : Proc
Global      Serial_Set_Rts          : Proc
Global      Serial_Reset_Rts        : Proc

Global      Serial_Buffer_Full      : Byte
Global      Serial_Stand_By         : Dword

COM_1               =       3F8h    ; base port address of port 0
COM_2               =       2F8h    ; base port address of port 1

SER_BAUD_300        =       384     ;    300 bauds
SER_BAUD_1200       =       96      ;   1200 bauds
SER_BAUD_2400       =       48      ;   2400 bauds
SER_BAUD_4800       =       24      ;   4800 bauds
SER_BAUD_9600       =       12      ;   9600 bauds
SER_BAUD_14400      =       8       ;  14400 bauds
SER_BAUD_19200      =       6       ;  19200 bauds
SER_BAUD_28800      =       4       ;  28800 bauds
SER_BAUD_38400      =       3       ;  38400 bauds
SER_BAUD_57600      =       2       ;  57600 bauds
SER_BAUD_115200     =       1       ; 115200 bauds

SER_STOP_1          =       0       ; 1 stop bit per character
SER_STOP_2          =       4       ; 2 stop bits per character

SER_BITS_5          =       0       ; send 5 bit characters
SER_BITS_6          =       1       ; send 6 bit characters
SER_BITS_7          =       2       ; send 7 bit characters
SER_BITS_8          =       3       ; send 8 bit characters

SER_PARITY_NONE     =       0       ; no parity
SER_PARITY_ODD      =       8       ; odd parity
SER_PARITY_EVEN     =       24      ; even parity


;Ŀ
; Serial_Open         this function sets the serial port up.               
;                                                                          
;In :                                                                      
;       EDX = base port address                                            
;       EAX = speed                                                        
;       ECX = config                                                       
;       EDI = buffer size                                                  
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       EAX = Circular buffer adrs                                         
;                                                                          
;        Carry = 1                                                         
;             Not Enough Memory                                            
;                                                                          
;
If Impossible
            mov edx,COM_1
            mov eax,SER_BAUD_115200
            mov ecx,SER_PARITY_NONE
            or  ecx,SER_BITS_8
            or  ecx,SER_STOP_1
            mov edi,1024
            call Serial_Open
            jc @@not_enough_memory
endif


;Ŀ
; Serial_Close       This procedure closes the serial port.                
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            call Serial_Close
endif


;Ŀ
; Serial_Read        This procedue reads a character in the circular buffer
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       al : char                                                          
;                                                                          
;
If Impossible
@@wait:
            cmp Serial_Stand_By,0
            je @@wait
            call Serial_Read
endif


;Ŀ
; Serial_Read_Block                                                        
;                                                                          
;In :                                                                      
;       EDI = Buffer adrs                                                  
;       ECX = Nbs char to read                                             
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            mov ecx,10
            lea edi,[Buffer]
            call Serial_Read_Block
endif


;Ŀ
; Serial_Write       This procedure sends characters.                      
;                                                                          
;In :                                                                      
;       bl  = char to write                                                
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Error To Write                                               
;                                                                          
;
If Impossible
            mov bl,'a'
            call Serial_Write
            jc @@error
endif


;Ŀ
; Serial_Write_Block                                                       
;                                                                          
;In :                                                                      
;       ESI = Buffer adrs                                                  
;       ECX = Nbs char to write                                            
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Error To Write                                               
;                                                                          
;
If Impossible
            mov ecx,10
            lea esi,[Buffer_To_Send]
            call Serial_Write_Block
            jc @@error
endif


;Ŀ
; Serial_Clear_Buffer This procedure clears the circular buffer.           
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            call Serial_Clear_Buffer
endif


;Ŀ
; Serial_Status      This procedure gets the status of the modem.          
;                                                                          
;Out :                                                                     
;       al = status                                                        
;                                                                          
;         7    6     5     4      3     2      1      0                    
;     Ŀ                  
;      DCD  RI  DSR  CTS  dDCD  dRI  dDSR  dCTS                   
;                       
;                                                                          
;     Bit 0 (dCTS): Change in CTS                                          
;     Bit 1 (dDSR): Change in DSR                                          
;     Bit 2 (dRI): Change in RI                                            
;     Bit 3 (dDCD): Change in DCD                                          
;     Bit 4 (CTS): Clear To Send. Modem sets this line indicating that     
;             it is ready for data, after computer indicates that it       
;             is ready for data with an RTS. It used to be a signal        
;             that the local modem has connected with a remote modem       
;             too, in the olden days.                                      
;     Bit 5 (DSR): Data Set Ready. This is the completing signal in a      
;             DTR-DSR pair. Computer sends DTR to modem, saying it         
;             wants to connect with it. Modem sends DSR back to            
;             computer, saying that connection has been established.       
;     Bit 6 (RI): Ring Indicator. Indicates that there is remote modem     
;             attempting to call your local modem.                         
;     Bit 7 (DCD): Data Carrier Detect. Indicates that the remote          
;             modem has established connection with local modem.           
;                                                                          
;
If Impossible
            call Serial_Status
endif


;Ŀ
; Serial_Set_Dtr     sets the DTR bit to 1                                 
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            call Serial_Set_Dtr
endif


;Ŀ
; Serial_Reset_Dtr   sets the DTR bit to 0                                 
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            call Serial_Reset_Dtr
endif

;Ŀ
; Serial_Set_Rts     sets the RTS bit to 1                                 
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            call Serial_Set_Rts
endif

;Ŀ
; Serial_Reset_Rts   sets the RTS bit to 0                                 
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;
If Impossible
            call Serial_Reset_Rts
endif



;ͻ
;                                                                          
; GIF                                                                      
;                                                                          
;ͼ

global Load_External_Gif_Handle     :proc
global Load_Internal_Gif_Handle     :proc
global gif_palette                  :dword
global gif_handle                   :dword
global gif_y                        :word
global gif_x                        :word

;Ŀ
;Load External Gif Handle   Load and uncompress a external GIF file.       
;                                                                          
;In :                                                                      
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = Logical (tasm) or physical (watcom) address of buffer        
;       EDI = Handle of Memory                                             
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
If Impossible
            mov edx,O File_name
            Call Load_External_Gif_Handle
            jc Error_File
            mov [File_Buffer],eax
            mov [Handle_Memory],edi
EndIf


;Ŀ
;Load Internal Gif Handle   Load and uncompress a internal GIF file.       
;                                                                          
;In :                                                                      
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = Logical (tasm) or physical (watcom) address of buffer        
;       EDI = Handle of Memory                                             
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
If Impossible
            mov edx,O File_name
            Call Load_Internal_Gif_Handle
            mov [File_Buffer],eax
            mov [Handle_Memory],edi
EndIf



;ͻ
;                                                                          
; CDROM                                                                    
;                                                                          
;ͼ

_Track_Info Struc
_adr        db 0
_track      db 0
_index      db 0
_min        db 0
_sec        db 0
_frame      db 0
_zero       db 0
_amin       db 0
_asec       db 0
_aframe     db 0
            ends

Global Track_Info   : _Track_Info

;Ŀ
;Detect CDROM  Detect is a cdrom is connected to the system using the      
;              MSCDEX functions                                            
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;        BX = Number of CDROM present                                      
;        CX = Drive of the First CDROM                                     
;        DX = MSCDEX version                                               
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 No CDROM detected                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Detect_CDROM    : proc
Global      First_CDROM     : word
Global      Number_CDROM    : word
Global      Version_MSCDEX  : word


;Ŀ
;Play a Track  Play a track from the CDROM                                 
;                                                                          
;In :                                                                      
;                                                                          
;       EAX = Track number                                                 
;       EBX = 0 this track only                                            
;             1 all tracks follow                                          
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on playing                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Play_Track : proc


;Ŀ
;Open CDROM   Open the CDROM door                                          
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Open_CDROM : proc


;Ŀ
;Close CDROM   Close the CDROM door                                        
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Close_CDROM : proc


;Ŀ
;Stop CDROM stop the music from the CDROM                                  
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Stop_CDROM : proc


;Ŀ
;Resume CDROM  Resume the music from the CDROM                             
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Resume_CDROM : proc


;Ŀ
;Get Nb Tracks Get the number of Tracks in the CDROM                       
;              (Will also reload all the database all track a bit slow)    
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;       EBX = Number of Track                                              
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Get_Nb_Tracks : proc
Global      Track_Nbs     : dword


;Ŀ
;Get Track Info  Get the Track info on the CDROM                           
;                                                                          
;In :                                                                      
;       EAX = Track number                                                 
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Get_Track_Info : proc


;Ŀ
;Get Current Track Info  Get the current Track info on the CDROM           
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = 0                                                            
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 Error on command                                           
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Global      Get_Current_Track_Info : proc


;ͻ
;                                                                          
; Macros used for calling the real mode                                    
;                                                                          
;ͼ

Global     Real_GS                 :dword
Global     Real_FS                 :dword
Global     Real_DS                 :dword
Global     Real_ES                 :dword
Global     Real_SS                 :dword
Global     Real_SP                 :dword

Int_Val_DOS = 62h
Int_Val_Call= 63h

DosInt     macro Int_Number
            push Int_Number
            int Int_Val_DOS
           endm

DosCALL    macro _Seg_,_Ofs_
           IFB <_Ofs_>
            push D _Seg_
           ELSE
            push W _Seg_
            push W _Ofs_
           ENDIF
            int Int_Val_Call
           endm

Init_es_di  macro Adrs
            mov edi,[Code32_Addr]
            add edi,O Adrs
            shr edi,4
            mov Real_ES,edi
            lea edi,Adrs
            and edi,0fh
            endm

Init_ds_dx  macro Adrs
            mov edx,[Code32_Addr]
            add edx,O Adrs
            shr edx,4
            mov Real_DS,edx
            lea edx,Adrs
            and edx,0fh
            endm


;ͻ
;                                                                          
; Miscellaneous                                                            
;                                                                          
;ͼ


Global       Code32_Sel              :word
Global       Data32_Sel              :word
Global       Flat_Data_Sel           :word
Global       Flat_Code_Sel           :word
Global       Environment_Addr        :dword
Global       Psp_Addr                :dword
Global       _0b0000h                :dword
Global       _0b8000h                :dword
Global       _0a0000h                :dword
Global       Code32_Addr             :dword
Global       Zero_Addr               :dword
Global       Start32                 :proc
Global       Server_Type             :Byte

;ͻ
;                                                                          
; The 32bit debugger                                                       
;                                                                          
;ͼ

Global       Debug                   :proc
Global       Debug_Back              :proc

;ͻ
;                                                                          
; The EOS Emutation when using WATCON                                      
;                                                                          
;ͼ

Global       Init_EOS                :proc