unit fm32;
{


FLAT MAQUINA 32 BIT VERSION 2.01 by MORBID IADALBAOTH/ MUTANTE
(c) 1997

FM32-PASCAL IMPLEMENTATION

I hope this piece of code will be useful for those who does pascal hybrid
coding and yet want the access to the flat memory wonderland.

The ZIP should include:
    FM32.pas   --- this file
    LLANO.obj  --- object code for switch to protected mode and back
    TEST.pas   --- example code to use this unit FM32!
    FILE_ID.diz--- hmm.....

Feel free to use in any non-commercial product. A postcard or simply
credit would be nice. For more readup, get DOS INTERNALS by Geoff Chappell
(Addison Wesley). Be glad if ye can kindly report any bugs to me.

email: eng60405@leonis.nus.sg
webby: http://www.webvillage.com/morbid/mutante.html

Dated: 10/3/97


}
interface

var
   xms_addr,
   xmsaddress:longint;
   xmshandle :word;

function  XMSinit:byte;
function  VIRTUAL86:word;
function  XMSlocal_enable_A20:word;
function  XMSqueryfree:word;
function  XMSalloc(kbytes:word):word;
function  XMSfree(handle:word):word;
function  XMSlock(handle:word):longint;
procedure XMSunlock(handle:word);
procedure START;
function  OPEN_FILE32(fname:string;var fhandle32:word):byte;
function  LOADHIGH_F32(fhandle32:word;buffer:pointer;fsize,faddr:longint):byte;

implementation

procedure frmi_start;external;
{$l llano.obj}

{$F+}
{

XMS initialization
Return: AL= status code
            00h success
                [xms_address]=XMS driver address
            01h failure

}
function XMSinit:byte;assembler;
asm
	mov ax,4300h
	int 2Fh
	cmp al,80h
	je @XMSOK1
        mov al,1
        ret

     @XMSOK1:
	mov ax,4310h
	int 2Fh
	mov ax,es
	db 66h,0c1h,0e0h,16h                            {  asm shl eax,16  }

	mov ax,bx
	mov word ptr xms_addr[0],bx
	mov word ptr xms_addr[2],es

	mov ah,0
	mov dx,0
	call dword ptr xms_addr

	cmp ah,2
	jae @XMSOK2
        mov al,1
        ret
     @XMSOK2:
        mov al,0
end;

{

Check CPU in V86 mode:
        By checking the VM bit of CR0
Return: AX =0001h V86 mode

}
function virtual86:word;assembler;
asm
   db 0fh,20h,0c0h                                     {  asm mov eax,cr0  }
   and ax,1
end;

{

Call the XMS driver "Local enable A20" function with:
	AH = 05h
Return: AX = status
	    0001h success
	    0000h failure
		BL = error code (80h,81h,82h)
Note:	this function is used for direct access to extended memory

}
function XMSlocal_enable_A20:word;assembler;
asm
	mov ah,05h
	mov dx,0
	call dword ptr [xms_addr]
end;

{

Call the XMS driver "Query free extended memory" function with:
	AH = 08h
	BL = 00h (some implementations leave BL unchanged on success)
Return: AX = size of largest extended memory block in KB
	DX = total extended memory in KB
	BL = error code (00h,80h,81h,A0h) (see #1334)
Note:	this function does not include the HMA in the returned memory sizes

}
function  XMSqueryfree:word;assembler;
asm
	mov ah,08h
	xor dx,dx
	call dword ptr [xms_addr]
	mov ax,dx
end;


{

Call the XMS driver "Allocate extended memory block" function with:
	AH = 09h
	DX = Kbytes needed
Return: AX = status
	    0001h success
		DX = handle for memory block
	    0000h failure
		BL = error code (80h,81h,A0h)

}
function XMSalloc(kbytes:word):word;assembler;
asm
        mov ah,09h
        mov dx,kbytes
	call dword ptr [xms_addr]

	cmp ax,01h
	je @ALLOCOK
	mov ax,0ffffh
        ret
     @ALLOCOK:
	mov ax,dx
end;

{

Call the XMS driver "Free extended memory block" function with:
	AH = 0Ah
	DX = handle of block to free
Return: AX = status
	    0001h success
	    0000h failure
		BL = error code (80h,81h,A2h,ABh) (see #1334)

}
function XMSfree(handle:word):word;assembler;
asm
        mov ah,0ah
        mov dx,handle
	call dword ptr [xms_addr]
end;

{

Call the XMS driver "Lock extended memory block" function with:
	AH = 0Ch
	DX = handle of block to lock
Return: AX = status
	    0001h success
		DX:BX = 32-bit linear address of locked block
	    0000h failure
		BL = error code (80h,81h,A2h,ACh,ADh)
Note:	MS Windows 3.x rejects this function for handles allocated after
	  Windows started

}
function XMSlock(handle:word):longint;assembler;
asm
        mov ah,0ch
        mov dx,handle
	call dword ptr [xms_addr]
        cmp al,1h
        je @LOCKOK
	mov ax,0
	mov dx,0
        ret
     @LOCKOK:
	mov ax,bx
end;

{

Call the XMS driver "Unlock extended memory block" function with:
	AH = 0Dh
	DX = handle of block to unlock
Return: AX = status
	    0001h success
	    0000h failure
		BL = error code (80h,81h,A2h,AAh)

}
procedure XMSunlock(handle:word);assembler;
asm
        mov ah,0dh
        mov dx,handle
	call dword ptr [xms_addr]
end;

{

Flat Real Mode Maquina setup



}
procedure start;
begin
   writeln;
   writeln('El Mquina la Realmente-Llano Mode ver 1.21');
   writeln('code por Morbid Iadalbaoth/Mutante 1997 Jan');
   writeln;
   if (virtual86=1)  then
   begin
        writeln('Mquina en mode la virtual 8086, tirar QEMM y otro driver parecido');
        halt;
   end;

   frmi_start;

   if (XMSinit=1) then
   begin
       writeln('No XMS-driver encontrado o demasiado viejo');
       halt;
   end;
   if XMSlocal_enable_A20=1 then
       writeln('Local A20 line   : enabled!')
   else
       begin
           writeln ('Local A20 line   : unable to set!');
           halt;
       end;

   writeln('memory libre     : ',xmsqueryfree,'KB');
end;


{

Open file
Input: string fname             filename to open
       word fhandle32           pointer to file handle
Returns: error code
           AL=0 success
             =1 failure
         File handle stored in *fhandle
NOTE: Remember to add char $0 at the end of the fname string!!!

}
function OPEN_FILE32(fname:string;var fhandle32:word):byte;assembler;
asm
        mov ax, 3d00h                            { read-only mode          }
        mov dx, word [bp+10]                     { ds:dx <- fname          }
        mov bx, word [bp+12]
        inc dx
        push ds
        mov ds,bx
        int  21H                                 { open file               }
        pop ds

        jnc @FILEFOUND
        mov al,1                                 { error code 1            }
        jmp @FIN

     @FILEFOUND:
        mov di,word [bp+6]                       { es:di <- fhandle32      }
        mov dx,word [bp+8]
        mov es,dx
        stosw                                    { return handle           }
        xor ax,ax                                { error code 0            }
     @FIN:
end;

{

Read file into extended memory
Input: word fhandle32         file handle
       ptr  buffer            pointer to 64k buffer
       long fsize             number of bytes to read
       long faddr             absolute address of XMS memory to write

Returns: error code
           AL=0 success
             =1 failure

NOTE: This function LSEEK from the end of file by fsize before reading.

}
function loadhigh_f32(fhandle32:word;buffer:pointer;fsize,faddr:longint):byte;assembler;
asm
        mov bx,word [bp+18]                       { bx <- file handle       }

        mov cx,word [bp+12]                       { cx:dx <- read size      }
        mov dx,word [bp+10]
        neg dx
        not cx
        mov ax,4202h
        int 21h                                   { move file pointer       }

        db 66h,8bh,4eh,0ah                        { mov ecx,[bp+8]          }
                                                  { ecx <- read size        }
        mov di,word [bp+8]
        db 66h,0c1h,0e7h,10h                      { shl edi,16              }
        mov di,word [bp+6]
        xor ax,ax
        mov es,ax                                 { es:edi <- faddr         }

     @READLOOP:
        db 66h,83h,0f9h,00h                       { cmp ecx,0               }
        je @READOK

        db 66h,81h,0f9h,0fch,0ffh,00h,00h         { cmp ecx,0fffch          }
        jbe @READREST

        mov ax,3f00h
        db 66h,51h                                { push ecx                }
        mov cx,0fffch
        push ds
        lds dx,buffer
        int 21h                                   { read data to buffer     }
        pop ds
        db 66h,59h                                { pop ecx                 }

        jc @ERROR

        push ds
        db 66h,51h                                { push ecx                }
        lds si,buffer
        mov cx,3fffh

     @AGAIN:
        db $3e,$66,$8b,$04                        {mov eax,[si]             }
        add si,4
        db $26,$67,$66,$89,$07                    {mov es:[edi],eax         }
        db $66,$83,$c7,$04                        {add edi,4                }
        loop @AGAIN
        db 66h,59h                                { pop ecx                 }
        pop ds

        db 66h,81h,0e9h,0fch,0ffh,00h,00h         { sub ecx,0fffch          }
        jmp @READLOOP

     @READREST:
        mov ax,3f00h
        db 66h,51h                                { push ecx                }
                                                  {  mov cx,readsize        }
        push ds
        lds dx,buffer
        int 21h                                   {read data to buffer      }
        pop ds
        db 66h,59h                                { pop ecx                 }

        jc @ERROR

        push ds
        db 66h,51h                                { push ecx                }
        lds si,buffer
        mov cx,3fffh

     @AGAIN2:
        db $3e,$66,$8b,$04                        {mov eax,[si]             }
        add si,4
        db $26,$67,$66,$89,$07                    {mov es:[edi],eax         }
        db $66,$83,$c7,$04                        {add edi,4                }
        loop @AGAIN2
        db 66h,59h                                { pop ecx                 }
        pop ds

     @READOK:
        xor ax,ax
        jmp @FIN
     @ERROR:
        mov al,1
     @FIN:
end;
{$F-}

end.
