;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; constants, hardware specific
DMA_16bit          EQU   10110010B ; 16 bit, dac, single, fifo disable,0
Cmd_OutputRate     EQU   41H

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific variables

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific functions and macros

SB16_Playback      PROC  NEAR
                   SHL   DMALen,1
                   DEC   DMALen
                   MOV   AL,B CFG_SecondaryDMA
                   MOV   EBX,DMABuffer
                   MOVZX ECX,DMALen
                   ;ADD   ECX,ECX
                   ;DEC   ECX
                   CALL  COMM_DMARead
                   WriteDSP Cmd_OutputRate
                   WriteDSP 56H
                   WriteDSP 22H
                   WriteDSP DMA_16bit
                   WriteDSP 00100000B
                   DEC   DMALen
                   WriteDSP <BYTE PTR DMALen>
                   WriteDSP <BYTE PTR DMALen+1>
                   RET
SB16_Playback      ENDP

SB16_Playback2     PROC NEAR
                   SHL   DMALen,1
                   DEC   DMALen
                   MOV   AL,B CFG_SecondaryDMA
                   MOV   EBX,DMABuffer
                   MOVZX ECX,DMALen
                   ;ADD   ECX,ECX
                   ;DEC   ECX
                   CALL  COMM_DMARead
                   WriteDSP DMA_16bit
                   WriteDSP 00100000B
                   DEC   DMALen
                   WriteDSP <BYTE PTR DMALen>
                   WriteDSP <BYTE PTR DMALen+1>
                   RET
SB16_Playback2     ENDP

SB16_IRQ           PROC
                   ;CLI
                   PushSegs
                   ReLoadSegs
                   PUSHAD
                   MOV   DX,SBP_DataAvail16
                   IN    AL,DX          ; ack irq to blaster

                   CMP   Buffer0Played,FALSE
                   JNZ   @@Here

                   MOV   EAX,Buffer0Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer0Len
                   MOV   DMALen,AX
                   MOV   EAX,Buffer1Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer1Len,EAX
                   JMP   @@Done

@@Here:            MOV   EAX,Buffer1Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer1Len
                   MOV   DMALen,AX
                   MOV   EAX,Buffer0Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer0Len,EAX

@@Done:            CMP   SB_ShutDown,TRUE
                   JZ    @@ShutDown
                   CALL  SB16_Playback2
                   CALL  SB16_TickHandler
                   NOT   Buffer0Played
@@ShutDown:        MOV   SB_ShutDown,FALSE

                   POPAD
                   PUSH  AX
                   MOV   AL,20H
                   CMP   SB_PIC1,TRUE
                   JNZ   @@pic0
                   OUT   0A0H,AL
@@pic0:            OUT   20H,AL
                   POP   AX
                   PopSegs
                   ;STI
                   IRETD
SB16_IRQ           ENDP

SB16_IRQInit       PROC  NEAR
                   CLI
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EAX,CFG_IRQNumTable[ESI*2]

                   MOV   EBX,O SB16_IRQ
                   MOV   CX,CS
                   CALL  COMM_HookIRQ
                   MOV   D OldIRQ,EBX
                   MOV   W OldIRQ+4,CX

                   MOV   SB_PIC1,FALSE
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQNumTable[ESI*2]
                   CMP   BL,8
                   JB    @@PIC0
                   MOV   SB_PIC1,TRUE
@@PIC0:            MOVZX EBX,BL

                   CALL  GetIRQMasks
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQMaskTable[ESI*2]
                   NOT   BX
                   AND   AX,BX
                   CALL  SetIRQMasks

                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EBX,W CFG_IRQNumTable[ESI*2]
                   CALL  EnableCallBack
                   STI

                   MOV   Buffer0Played,TRUE

                   MOV   EAX,Buffer0Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer0Len,EAX
                   CALL  SB16_TickHandler
                   MOV   EAX,Buffer1Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer1Len,EAX
                   CALL  SB16_TickHandler

                   MOV   EAX,Buffer0Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer0Len
                   MOV   DMALen,AX
                   CALL  SB16_Playback
                   RET
SB16_IRQInit       ENDP

SB16_IRQDone       PROC  NEAR
                   CALL  SB_SpkOff
                   MOV   SB_ShutDown,TRUE
@@WaitShutDown:    CMP   SB_ShutDown,FALSE
                   JNZ   @@WaitShutDown
                   CLI
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EBX,W CFG_IRQNumTable[ESI*2]
                   CALL  DisableCallBack

                   CALL  GetIRQMasks
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQMaskTable[ESI*2]
                   AND   BX,NOT 4
                   OR    AX,BX
                   CALL  SetIRQMasks

                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EAX,CFG_IRQNumTable[ESI*2]
                   MOV   EBX,D OldIRQ
                   MOV   CX,W OldIRQ+4
                   CALL  COMM_HookIRQ
                   STI

                   RET
SB16_IRQDone       ENDP

SB16_Init          PROC  NEAR
                   PUSHAD
                   CALL  SB_Init
                   IFDEF SND_DOAMP
                   MOV   EAX,AmpTable
                   MOV   AmpTable1R,EAX
                   MOV   AmpTable1L,EAX
                   ENDIF
                   CALL  ModifyMulTable
                   ;CLR   EAX
                   ;CALL  SBP_MixerWrite ; reset mixer
                   MOV   EAX,0AA22H ; master volume
                   CALL  SBP_MixerWrite
                   MOV   EAX,0AA24H ; dsp output
                   CALL  SBP_MixerWrite
                   ;MOV   EAX,0130EH ; set stereo output
                   ;CALL  SBP_MixerWrite

                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,MixingChannels
@@PanLp:           MOV   EAX,MixingChannels
                   SUB   EAX,ECX
                   MOV   AL,DefaultPanning[EAX]
                   MOV   [ESI.CI_Panning],AL
                   ADD   ESI,Size ChannelInfo
                   LOOP  @@PanLp
                   POPAD
                   RET
SB16_Init          ENDP

SB16_Done          PROC  NEAR
                   JMP   SBP_Done
SB16_Done          ENDP

