
;ͻ;
; DPMI initialization and system functions                                  ;
;ͼ;


; Number of DPMI selectors
NUMBER_DPMI_SELECTORS     EQU     (4)


Kernel  SEGMENT
        ASSUME CS:Kernel, DS:Code32

;Ŀ;
; Generic DPMI Error Exit                                                   ;
;;
DPMI_ErrorExit:
  mov dx,m o DPMI_GenErrorMSG
  jmp ErrorExit

DPMI_GenErrorMSG db 'DPMI initialization error.',0Ah,24h


;Ŀ;
; DPMI system initialization                                                ;
;;
DPMI_System:

  mov m pm_EntryType,pm_ENTRY_DPMI      ; DPMI entry

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ; Save DPMI mode-switch entry point
  mov m w DPMI_ModeSwitch  ,di
  mov m w DPMI_ModeSwitch+2,es

  ; Test for 32-bit Protected Mode support
  and bx,1
  jz DPMI_ErrorExit

  ; Allocate memory for use by DPMI if necessary
  test si,si
  jz EnterDPMI_ProtMode
  mov bx, si
  mov ah, 48h
  int 21h
  jc DPMI_ErrorExit
  mov es, ax

  ; Enter protected mode as a 32-bit program
  EnterDPMI_ProtMode:
  mov ax,1
  call m DPMI_ModeSwitch
  jc DPMI_ErrorExit


;*****************************************************************************;
  ; In 16-bit protected mode.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; Allocate and set descriptors
  push ds
  pop es
  mov edi,o GDT + 8
  mov esi,o Selectors
  mov dx,NUMBER_DPMI_SELECTORS
  SelLoop:
    ; Allocate LDT descriptor
    xor ax,ax
    mov cx,1
    int 31h
    ; Save selector
    mov [esi],ax
    add esi,2
    ; Set descriptor
    mov bx,ax
    mov ax,000Ch
    or b [edi+5],01100000b    ; set CPL 3
    int 31h
    add edi,8
    dec dx
    jnz SelLoop

  mov ax,m Data32Sel
  mov ds,ax
  mov es,ax


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; Hook Real Mode Interrupt Call
  mov ax,205h
  mov bl,rm_INTCALL_VECTOR
  mov cx,m Code32Sel
  mov edx,l o DPMI_rm_IntCall
  int 31h


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; update pointers to system functions
  mov GetPMInt,o DPMI_Get_pm_Int
  mov SetPMInt,o DPMI_Set_pm_Int


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; Jump to USE32 segment
  push m d Code32Sel
  push l o Enter32
  db 66h, 0CBh


;*****************************************************************************;
Kernel  ENDS



;*****************************************************************************;
Code32 SEGMENT
  ASSUME CS:Code32, DS:Code32, SS:Code32

  ; DPMI Mode switch routine (real mode)
DPMI_ModeSwitch   dd      0


;Ŀ;
; DPMI Real Mode call back                                                  ;
;;
DPMI_rm_IntCall:

  mov v_ESP,esp                 ; save ESP

  sub esp,6*2                   ; make room for SS, SP, CS, IP, GS, FS

  push m rm_SegRegs             ; store DS, ES
  pushfw                        ; store Flags
  pushad                        ; store EAX,ECX,EDX,EBX,ESP,EBP,ESI,EDI

  ; pointer to real mode call back structure
  mov edi,esp

  ; Calculate real mode stack address
  mov eax,m d rm_SS
  mov [edi+48],ax               ; store SS
  shl eax,4
  sub eax,esp
  neg eax
  add eax,m Code32addr
  mov [edi+46],ax               ; store SP

  ; Simulate real mode interrupt
  mov ax,0300h
  mov bx,m w rm_Int
  xor ecx,ecx
  int 31h

  popad                         ; restore EAX,ECX,EDX,EBX,ESP,EBP,ESI,EDI
  popfw                         ; restore Flags
  pop m rm_SegRegs              ; restore DS, ES
  mov esp,v_ESP                 ; restore ESP

  retf 4


;Ŀ;
; Get protected mode interrupt descriptor                                   ;
; Entry:  BL - Interrupt vector                                             ;
; Exit :  AX:EDX - Selector:offset of interrupt vector                      ;
;;
DPMI_Get_pm_Int:
  push ecx
  mov ax,0204h
  int 31h
  mov eax,ecx
  pop ecx

  ret


;Ŀ;
; Set protected mode interrupt descriptor                                   ;
; Entry:  BL - Interrupt Vector                                             ;
;         AX:EDX - Selector:offset of interrupt vector                      ;
;;
DPMI_Set_pm_Int:
  push ecx
  mov ecx,eax
  mov ax,0205h
  int 31h
  pop ecx

  ret


Code32 ENDS

