
;ͻ;
; Text output routines                                                      ;
;ͼ;


Code32 SEGMENT
  ASSUME CS:Code32, DS:Code32, SS:Code32

;Ŀ;
; Print a hex DWORD                                                         ;
; Entry: EAX - DWORD to print                                               ;
;;
PrintDWORDh:
  pushad
  mov ecx,8
;  jmp _PrintHex


;Ŀ;
; Print N hex digits                                                        ;
; Entry: EAX - number to print with first digit in most significant nibble  ;
;        ECX - number of digits                                             ;
;        Stack - All registers pushed (PUSHAD)                              ;
;;
_PrintHex:
  @@10:
    xor ebx,ebx
    shld ebx,eax,4
    shl eax,4
    mov dl,HexTAB+ebx
    push eax
    mov ah,2
    int 21h
    pop eax
    loop @@10
  popad
  ret


;Ŀ;
; Print a hex WORD                                                          ;
; Entry:  AX - WORD to print                                                ;
;;
PrintWORDh:
  pushad
  mov ecx,4
  shl eax,16
  jmp _PrintHex


;Ŀ;
; Print a hex BYTE                                                          ;
; Entry:  AL - BYTE to print                                                ;
;;
PrintBYTEh:
  pushad
  mov ecx,2
  shl eax,24
  jmp _PrintHex


;Ŀ;
; Print a DWORD                                                             ;
; Entry: EAX - DWORD to print                                               ;
;;
PrintDWORD:
  pushad
;  jmp _PrintDWORD


;Ŀ;
; Print a DWORD                                                             ;
; Entry: EAX - DWORD to print                                               ;
;        Stack - All registers pushed (PUSHAD)                              ;
;;
_PrintDWORD:
  mov ebx,10
  xor ecx,ecx
  @@10:
    xor edx,edx
    div ebx
    add dl,'0'
    push edx
    inc ecx
    test eax,eax
    jnz @@10
  mov ah,2
  @@20:
    pop edx
    int 21h
    loop @@20
  popad

  ret


;Ŀ;
; Print a WORD                                                              ;
; Entry:  AX - WORD to print                                                ;
;;
PrintWORD:
  pushad
  movzx eax,ax
  jmp _PrintDWORD


;Ŀ;
; Print a BYTE                                                              ;
; Entry:  AL - BYTE to print                                                ;
;;
PrintBYTE:
  pushad
  movzx eax,al
  jmp _PrintDWORD

Code32 ENDS
