/*
** LCR.C   Communication Port Test Code
**
** Coded by : James P. Ketrenos
**
** 	You have permission to use this if you want.  You are not required
** 	to use it.  However, if it should cause harm to you, your computer,
**  your dog, or anyone/thing you know/have/own, I am not responsible.
**
**  By using this, or any file in this archive, you acknowledge that
**  fact and accept it.
**
*/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "ll_comm.h"
#include "ll_stat.h"

#define VER_ID  "0001.3000"

int 	COM_BASE=0x3F8;
int 	COM_IRQ=4;
int 	COM_RATE=57600;
int 	COM_SET=(BITS_8 | STOP_1 | NO_PARITY);
int 	COM_FIFO=0;
COMM	Port;

int 	ECHO=0;
int 	LF=0;
int 	xpos,ypos=0;
char	*screen=(char *)0x000b8000;

ClearIO()
{
int x;
	for (x=0; x<80*25*2; x+=2)
	{
		screen[x]=0;
		screen[x+1]=7;
	}
	xpos=ypos=0;
}

PrintIO(char	key)
{
	switch (key)
    {
    case    9:xpos+=10;
            if (xpos>160)
			{
				xpos=0;
				ypos++;
				if (ypos>24)
				{
					ClearIO();
					ypos=0;
				}
            }
            break;
    case	8:xpos-=2;
			if (xpos<0) xpos=0;
			screen[ypos*160+xpos]=0;
			break;
	case	13:xpos=0;
            break;
	case	10:ypos++;
			if (ypos>24)
			{
				ClearIO();
				ypos=0;
			}
			break;
	default:screen[ypos*160+xpos]=key;
			xpos+=2;
            if (xpos>160)
			{
				xpos=0;
				ypos++;
				if (ypos>24)
				{
					ClearIO();
					ypos=0;
				}
            }
	}
}

WriteStr(COMM Port, char	*str)
{
	for (; *str; str++)
		ioWriteByte(Port, *str);
}

PrintStr(char	*str)
{
	for (; *str; str++)
		PrintIO(*str);
}

int	main(int argc, char *args[])
{
int     key,count,prior;
int 	COM_TEMP;
int 	Escape=0;

    status(ST_RESET,"LCR.LOG");
	status(ST_ECHO,"");
    status(ST_SHOW,"[ LCR (R) Logical Comm Routines v%s ]",VER_ID);
	status(ST_ECHO,"[ Copyright (C) 1994  by J.P.K. ]");
	status(ST_ECHO,"");
    status(ST_ECHO,"See LCR.NFO for important information.");
	status(ST_SHOW,"");

	for (count=1; count<argc; count++)
	{
		if (args[count][0]!='-' && args[count][0]!='/')
		{
			status(ST_SHOW,"Bad command line.  -? for help.");
			exit(-1);
		}
		switch (args[count][1])
		{
		case	0:
        case    '?':printf("Usage:  LCR [ -[ [[?pbifBS]#] [P[NOEMS]] ] ]\n");
					printf("Where:  p       = Port (HEX)    (3E8, 2E8, etc)         [3E8]\n");
					printf("        b       = Baud (DEC)    (1 - 115200)            [57600]\n");
					printf("        i       = IRQ  (DEC)    (0 - 7)                 [4]\n");
					printf("        f       = FIFO Buffer   (0,1,4,8,14)            [0]\n");
					printf("        B       = Bits Per Word (5-8)                   [8]\n");
					printf("        S       = Stop Bits     (1-2)                   [1]\n");
					printf("        P       = Parity                                [NONE]\n");
					printf("                : None, Odd, Even, Mark, Space\n");
					printf("\n");
					printf("NOTE:  	5 Bits with 1 Stop Bit *may* not work with your\n");
					printf("        hardware.\n");
					exit(0);
		case	'p':sscanf(&args[count][2],"%x",&COM_BASE);
					printf("Port set to: 0x%X\n",COM_BASE);
					break;
		case	'b':sscanf(&args[count][2],"%d",&COM_RATE);
					if (COM_RATE < 1 || COM_RATE > 115200)
					{
						status(ST_SHOW,"Invalid Baud Rate.  Valid Range 1 - 115200.");
						exit(-1);
					}
					printf("Baud set to: %d\n",COM_RATE);
					break;
		case	'i':sscanf(&args[count][2],"%d",&COM_IRQ);
					if (COM_IRQ&!0x07)
					{
						status(ST_SHOW,"Invalid IRQ.  Valid Range 0 - 7.");
						exit(-1);
					}
					printf("IRQ  set to: %d\n",COM_IRQ);
					printf("Interrupt  : %d\n",COM_IRQ+8);
					break;
		case	'f':sscanf(&args[count][2],"%d",&COM_FIFO);
					switch (COM_FIFO)
					{
					case	0:case	  1:case	4:case	  8:case	14:
							break;
					default:status(ST_SHOW,"Invalid FIFO.  Valid Values (0,1,4,8,14).");
							exit(-1);
					}
					printf("FIFO  set to: %d\n",COM_FIFO);
					break;
		case	'B':sscanf(&args[count][2],"%d",&COM_TEMP);
					switch (COM_TEMP)
					{
					case	5:case	  6:case	7:case	  8:
							COM_SET&=CLEAR_BITS;
							COM_SET|=COM_TEMP-5;
							break;
					default:status(ST_SHOW,"Invalid BIT Size.  Valid Range 5 - 8.");
							exit(-1);
					}
					printf("Bits per word set to: %d\n",COM_TEMP);
					break;
		case	'S':sscanf(&args[count][2],"%d",&COM_TEMP);
					switch (COM_TEMP)
					{
					case	1:case	  2:
							COM_SET&=CLEAR_STOP;
							COM_SET|=(COM_TEMP-1)<<2;
							break;
					default:status(ST_SHOW,"Invalid STOP Count.  Valid Range 1 - 2.");
							exit(-1);
					}
					printf("Stop Bits set to: %d\n",COM_TEMP);
					break;
		case	'P':COM_TEMP=(int)args[count][2];
					switch (COM_TEMP<'a' ? COM_TEMP-'A'+'a' : COM_TEMP)
					{
					case	'n':
							COM_SET&=CLEAR_PARITY;
							printf("Parity set to: NONE\n");
							break;
					case	'o':
							COM_SET&=CLEAR_PARITY;
							COM_SET|=ODD_PARITY;
							printf("Parity set to: ODD\n");
							break;
					case	'e':
							COM_SET&=CLEAR_PARITY;
							COM_SET|=EVEN_PARITY;
							printf("Parity set to: EVEN\n");
							break;
					case	'm':
							COM_SET&=CLEAR_PARITY;
							COM_SET|=MARK_PARITY;
							printf("Parity set to: MARK\n");
							break;
					case	's':
							COM_SET&=CLEAR_PARITY;
							COM_SET|=SPACE_PARITY;
							printf("Parity set to: SPACE\n");
							break;
					default:status(ST_SHOW,"Invalid PARITY.  Valid types:");
							status(ST_SHOW,"    None, Odd, Even, Mark, Stop");
							exit(-1);
					}
					break;
		default:	status(ST_SHOW,"Bad command line.  -? for help.");
					exit(-1);
		}
	}

	printf("\n");
	status(ST_WRITE,"[ Command Line Parsed ]");
	status(ST_WRITE,"Base Port        : 0x%X",COM_BASE);
	status(ST_WRITE,"Port IRQ         : %d",COM_IRQ);
	status(ST_WRITE,"Port Interrupt   : 0x%X",COM_IRQ+8);
	status(ST_WRITE,"FIFO Buffer      : %d",COM_FIFO);
	status(ST_WRITE,"Baud Rate        : %d",COM_RATE);
	status(ST_WRITE,"Control Settings : 0x%X",COM_SET);
	status(ST_WRITE,"");

	switch(COM_BASE)
	{
	case	0x3E8:case 0x3F8:case 0x2E8:case 0x2F8:
			break;
	default:	status(ST_SHOW,"WARNING:  0x%X unrecognized as standard port base.",COM_BASE);
				printf("Are you sure you wish to use it? (y/N)\n");
				switch (getche())
				{
				case	'Y':case 'y':
						break;
				default:printf("\nExiting...\n");
						exit(-1);
				}
				printf("\n");
				while (kbhit()) getch();
	}

	status(ST_SHOW,"[ Initializing Port ]");
	Port=ioOpenPort(COM_BASE, COM_IRQ);
	if(!Port)
	{
		status(ST_SHOW,"Error initalizing port.\n");
		return	1;
	}
	status(ST_WRITE,"Latched Port ID at (struct PortID *)0x%X",Port);
	status(ST_WRITE,"");

	ioSetBaud(Port, COM_RATE);
	ioSetHandShake(Port, DTR | RTS);
	ioSetControl(Port, COM_SET);
	ioSetMode(Port, BYTE_MODE);

	ClearIO();
	PrintStr("Initializing Modem . . .\n\r");
	WriteStr(Port, "AT&F\r");

	while (!Escape)
	{
		while (!kbhit() && !ioReadStatus(Port));
		if (kbhit())
			switch (key=getch())
			{
			case	27: Escape=1;
						break;
			case	0:case 0xE0:
					if (kbhit())
						switch (key=getch())
						{
						case	0x12:ECHO=1-ECHO;
									PrintStr("\n\r[ECHO ");
									PrintStr(ECHO ? "ON" : "OFF");
									PrintStr("]\n\r");
									break;
						case	0x26:LF=1-LF;
									PrintStr("\n\r[LF ");
									PrintStr(LF ? "ON" : "OFF");
									PrintStr("]\n\r");
									break;
						case	0x17:WriteStr(Port,"AT&F\r");
									break;
                        case    0x3B:PrintStr("\n\r[ LCR:  Help ]\n\r");
									PrintStr("ALT-E     Toggle ECHO ON/OFF\n\r");
									PrintStr("ALT-I     Initialize Modem\n\r");
									PrintStr("ALT-L     Toggle LineFeeds\n\r");
									PrintStr("F1        Help\n\r");
									PrintStr("F2        Clear Screen\n\r");
									PrintStr("F3        Cool message\n\r");
									PrintStr("F4        Dial DeadMan' Hand\n\r");
									PrintStr("F5        Dial PSU #1\n\r");
									PrintStr("F6        Dial PSU #2\n\r");
									PrintStr("ESC       Exit\n\r");
									break;
						case	0x3C:ClearIO(); break;
						case	0x3D:PrintStr("\n\r[LL is ");
									PrintStr(ECHO ? "cool" : "neato");
									PrintStr("]\n\r");
									break;
						case	0x3E:WriteStr(Port, "ATDT9,2889264\r");
									break;
						case	0x3F:WriteStr(Port,"ATDT54206\r");
									break;
						case	0x40:WriteStr(Port,"ATDT53144\r");
									break;
						default:	break;
						}
					break;
			default:if (ECHO)
						PrintIO(key);
					ioWriteByte(Port, key);
					break;
			}
		if (ioReadStatus(Port))
            switch (key=ioReadByte(Port))
			{
			case	27: while (!kbhit() && !ioReadStatus(Port));
						if (ioReadByte(Port))
						{
							if (ioReadByte(Port)=='[')
							{
								PrintIO('E');
								PrintIO('[');
							}
						}
                        break;
            case    13: if (prior!=10)
                        PrintIO(10);
                        PrintIO(prior=13);
                        break;
            default:PrintIO(key);
                    prior=key;
					break;
			}
	}
	status(ST_SHOW,"[ Reseting Port ]");
	status(ST_WRITE,"");
	ioClosePort(Port);
	return	0;
}
