;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=- MAIN.ASM -- This small program sets mode 13h using my function          -=
;=-
;=- See the README.TXT file for the Disclaimer and other info               -=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
.MODEL  SMALL
.386
JUMPS
LOCALS
.STACK  100h
.DATA

ATTRCON_ADDR      EQU       03C0H
MISC_ADDR         EQU       03C2H
VGAENABLE_ADDR    EQU       03C3H
SEQ_ADDR          EQU       03C4H
GRACON_ADDR       EQU       03CEH
CRTC_ADDR         EQU       03D4H
STATUS_ADDR       EQU       03DAH

;These next four lines must be included only if you use the Mode 03h fucntions
oldmode db ?
oldmisc db ?
oldmask db ?
oldmem db ?

include mode03.fon
include mode03h.inc
include mode13h.inc

MSG1 DB 'Back in Text mode using our Mode 03h function.'
MSG2 DB 13,10,13,10,'Press any key to continue...','$'

.CODE

IODELAY MACRO
   REPT 8
      JMP $+2
   ENDM
ENDM

Start:
   MOV AX,@DATA
   MOV DS,AX

   ; Call my set mode 13h function
   MOV SI,OFFSET MODE13H
   CALL SETMODE

   ; Clear the screen to blue
   MOV AX,0A000H
   MOV ES,AX
   MOV EAX,01010101H
   XOR DI,DI
   MOV CX,16000
   CLD
   REP STOSD

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   ; Set Mode 03h
   MOV SI,OFFSET MODE03H
   CALL SETMODE
   ; Must do this to ensure proper text
   CALL SETFONT

   ; Clear the screen
   CALL CLRSCR

   ; Put the cursor at 0,0
   MOV AH,2H
   MOV BX,0
   MOV DX,0
   INT 10H

   ; Print out the message
   MOV DX,OFFSET MSG1
   MOV AH,9
   INT 21H

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   ; Set the BIOS mode 03h
   MOV AX,0003H
   INT 10H

   ; Exit to DOS
   MOV AX,4C00H
   INT 21H

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

   PUBLIC SETMODE
SETMODE PROC

   ; Send MISC regs
   CALL OUTREGS
   ADD SI,4

   MOV DX,STATUS_ADDR
   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY
   ADD SI,4

   ; Send SEQ regs
   MOV CX,5
REG_LOOP:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP

   ; Clear Protection bits
   MOV AH,0EH
   MOV AL,11H
   AND AH,7FH
   MOV DX,CRTC_ADDR
   OUT DX,AX
   IODELAY

   ; Send CRTC regs
   MOV CX,25
REG_LOOP2:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP2

   ; Send GRAPHICS regs
   MOV CX,9
REG_LOOP3:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP3

   MOV DX,STATUS_ADDR
   IN AL,DX
   IODELAY

   ; Send ATTRCON regs
   MOV CX,21
REG_LOOP4:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP4

   MOV AL,20H
   OUT DX,AL
   IODELAY

   RET
SETMODE ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

   PUBLIC OUTREGS
OUTREGS PROC

   MOV AX,[SI].PORT
   CMP AX,ATTRCON_ADDR
   JE CASE1
   CMP AX,MISC_ADDR
   JE CASE2
   CMP AX,VGAENABLE_ADDR
   JE CASE2
   JMP CASE3

CASE1:
   MOV DX,ATTRCON_ADDR
   IN AX,DX

   MOV AL,[SI].INDEX
   OUT DX,AL
   IODELAY

   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY
   JMP CASEOUT

CASE2:
   MOV DX,[SI].PORT
   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY
   JMP CASEOUT

CASE3:
   MOV DX,[SI].PORT
   MOV AL,[SI].INDEX
   OUT DX,AL
   IODELAY

   MOV DX,[SI].PORT
   INC DX
   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY

CASEOUT:
   RET
OUTREGS ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   PUBLIC SETFONT
SETFONT PROC                            ;
 mov dx,GRACON_ADDR                     ;get graphics port
 mov al,5                               ;get write mode reg
 out dx,al                              ;select the reg
 IODELAY                                ;delay a bit
 inc dx                                 ;change DX
 in al,dx                               ;get value
 IODELAY                                ;pause
 mov [oldmode],al                       ;store it
 dec dx                                 ;restore DX
 mov al,6                               ;get misc reg
 out dx,al                              ;select the reg
 IODELAY                                ;delay a bit
 inc dx                                 ;change DX
 in al,dx                               ;get value
 IODELAY                                ;pause
 mov [oldmisc],al                       ;store it
 dec dx                                 ;restore DX
 mov dx,SEQ_ADDR                        ;get sequencer port
 mov al,2                               ;get map mask reg
 out dx,al                              ;select the reg
 IODELAY                                ;delay a bit
 inc dx                                 ;change DX
 in al,dx                               ;get value
 IODELAY                                ;pause
 mov [oldmask],al                       ;store it
 dec dx                                 ;restore DX
 mov al,4                               ;get memory selector reg
 out dx,al                              ;select the reg
 IODELAY                                ;delay a bit
 inc dx                                 ;change DX
 in al,dx                               ;get value
 IODELAY                                ;pause
 mov [oldmem],al                        ;store it
 mov dx,GRACON_ADDR                     ;select graphics port
 mov al,5                               ;get write mode reg
 mov ah,[oldmode]                       ;get old value
 and ah,0fch                            ;mask it
 out dx,ax                              ;set new value
 IODELAY                                ;pause
 mov al,6                               ;get misc reg
 mov ah,[oldmisc]                       ;get old value
 and ah,0f1h                            ;mask it
 or ah,4                                ;set a flag
 out dx,ax                              ;set it
 IODELAY                                ;pause
 mov dx,SEQ_ADDR                        ;select sequencer port
 mov al,2                             ;get mask reg
 mov ah,4                               ;get new value
 out dx,ax                              ;set it
 IODELAY                                ;pause
 mov al,4                              ;get memory reg
 mov ah,[oldmem]                        ;get old value
 or ah,4                                ;set flag
 out dx,ax                              ;set value
 IODELAY                                ;pause
 mov ax,0a000h                          ;get seg of font mem
 mov es,ax                              ;in ES
 xor di,di                              ;zero destination
 mov si,offset font                     ;get source
 xor ch,ch                              ;clear entries count
 cld                                    ;set direction flag correctly
@@loop1:                                ;
 push di                                ;save destination
 mov cl,16                              ;bytes per font
@@loop2:                                ;
 movsb                                  ;move a byte
 dec cl                                 ;decrease count
 jnz @@loop2                            ;loop until all done
 pop di                                 ;restore destination
 add di,32                              ;update it
 dec ch                                 ;decrease outer count
 jnz @@loop1                            ;loop until all done
 mov dx,GRACON_ADDR                     ;get graphics port
 mov al,5                               ;get 1st reg
 mov ah,[oldmode]                       ;get old value
 out dx,ax                              ;set it
 IODELAY                                ;pause
 mov al,6                               ;get 2nd reg
 mov ah,[oldmisc]                       ;get old value
 out dx,ax                              ;set it
 IODELAY                                ;pause
 mov dx,SEQ_ADDR                        ;get seq port
 mov al,2                               ;get 3rd reg
 mov ah,[oldmask]                       ;get old value
 out dx,ax                              ;set it
 IODELAY                                ;pause
 mov al,4                               ;get 4th reg
 mov ah,[oldmem]                        ;get old value
 out dx,ax                              ;set it
 IODELAY                                ;pause
 ret                                    ;exit
SETFONT endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
CLRSCR PROC
   PUSHA

   MOV AX,0B800H ; Set the Video Memory Address
   MOV ES,AX
   XOR DI,DI

   MOV AH,00000111b ; Attribute
   MOV AL,' '       ; Character
   MOV CX,2000
   CLD
   REP STOSW    ; Move to memory

   ; Restore registers
   POPA
   RET 
CLRSCR ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

END Start
