;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-                                                                         -=
;=-        Source Code for switching Video Modes without using BIOS         -=
;=-                 November 20, 1997     Version 2.1                       -=
;=-                                                                         -=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-        See the README.TXT file for the Disclaimer and other info        -=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

SET_MODEX PROC
   MOV SI,OFFSET CHAIN4
   CALL SETMODE

   MOV DX,03C2H
   MOV AL,0E3H
   OUT DX,AL

   ; turn off write protect
   MOV DX,CRTC_ADDR
   MOV AL,11H
   OUT DX,AL
   INC DX
   MOV AL,2CH
   OUT DX,AL

   ; vertical total
   MOV DX,CRTC_ADDR
   MOV AL,06H
   OUT DX,AL
   INC DX
   MOV AL,0DH
   OUT DX,AL

   ; overflow register
   MOV DX,CRTC_ADDR
   MOV AL,07H
   OUT DX,AL
   INC DX
   MOV AL,3EH
   OUT DX,AL

   ; vertical retrace start
   MOV DX,CRTC_ADDR
   MOV AL,10H
   OUT DX,AL
   INC DX
   MOV AL,0EAH
   OUT DX,AL

   ; vertical retrace end AND wr.prot
   MOV DX,CRTC_ADDR
   MOV AL,11H
   OUT DX,AL
   INC DX
   MOV AL,0ACH
   OUT DX,AL

   ; vertical display enable end
   MOV DX,CRTC_ADDR
   MOV AL,12H
   OUT DX,AL
   INC DX
   MOV AL,0DFH
   OUT DX,AL

   ; start vertical blanking
   MOV DX,CRTC_ADDR
   MOV AL,15H
   OUT DX,AL
   INC DX
   MOV AL,0E7H
   OUT DX,AL

   ; end vertical blanking
   MOV DX,CRTC_ADDR
   MOV AL,16H
   OUT DX,AL
   INC DX
   MOV AL,06H
   OUT DX,AL

   MOV MODE_WIDTH,320
   MOV MODE_HEIGHT,240
   MOV WIDTH_BYTES,19200

   RET
SET_MODEX ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
