;/*************************************************************************
; *
; *     File        : TESTVESA.C
; *
; *     Description : Test Vesa mode - Initialize mode 640x480x256 in LFB
; *                   Poke some pixels in Linear Frame buffer
; *     Copyright (C) 1995,97 RealTech
; *
; ************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include "_standar.h"
#include "_wdpmi.h"
#include "_dpmi.h"
#include "_vesa.h"
#define	__DEBUG_H
#include "uvbelib.h"
#ifdef __WATCOM__
void waitvr (void);
#pragma aux waitvr =\
	"mov dx,3dah",\
	"wait1:",\
	"in al,dx",\
	"test al,8",\
	"jnz wait1",\
	"wait2:",\
	"in al,dx",\
	"test al,8",\
	"jz wait2",\
	modify [al dx];

#endif

int mode;

void DrawJulia(int DEEP,int MAXITER,float xmin,float xmax,float ymin,float ymax,float a,float b)
{
    float LX = abs(xmax) + abs(xmin), LY = abs(ymax) + abs(ymin),cx,cy,ccy;
    float dLY = LY/(float)modebuf.YResolution;
    float dLX = LX/(float)modebuf.XResolution;
    ushort *video=(ushort*)VESA.Video;
    long delta=(modebuf.BytesPerLine/2)-modebuf.XResolution;
    long y,x,k;
    for (y = 0;y<modebuf.YResolution;y++)
    {
	if (kbhit()) return;
	ccy = ymin + (float)y * dLY;
	for (x = 0;x<modebuf.XResolution; x++,video++)
	{
	    float cx2,cy2;
	    cx = xmin + (float)x * dLX;
	    cy = ccy;
	    k = DEEP;
	    cx2 = cx * cx;
	    cy2 = cy * cy;
	    do
	    {
		float x1 = cx2 - cy2 - a;
		cy = 2. * cx * cy - b;
		cx = x1;
		k--;
		cx2 = cx*cx;
		cy2 = cy*cy;
	    }while ( (cx2 + cy2 <= MAXITER) && (k!=0));
	    *video = RGBMask((x<<8)/modebuf.XResolution,(y<<8)/modebuf.YResolution,k<<3);
	}
	video+=delta;
    }
    return;
}

void set_vgamode(int a)
{
    __dpmi_regs regs;
    regs.x.ax = a;
    __dpmi_int(0x10,&regs);
    return;
}
void error(char *tx,int code)
{
    set_vgamode(0x3);
    fprintf(stderr,"%s code %d\n",tx,code);
    exit(-1);
}
void Disp_VSystem(void)
{
    printf("Realtech VESA Kit v2.10 (C) Copyright Realtech 1996\nhttp://www.worldnet.net/~stedenis\n\n");
    printf("VESA Version :%d.%d\n",vesabuf.VESAVersion>>8,vesabuf.VESAVersion&0xff);
    printf("Vendor       :%s\n",VESA.CardName);
    printf("LFB possible :%d\n",VESA.Linear);
    printf("LFB active   :%d\n",VESA.LFB_actived);
    printf("Selector     :0x%04x\n",VESA.selector);
    printf("Video Ptr    :0x%08x\n",(ulong)VESA.Video);
    printf("BankShift    :%d Granule:%d\n",VESA.bankshift,modebuf.WinGranularity);
    printf("Video Mode %x: %d x %d (scanlength:%d)\n\n",mode,modebuf.XResolution,modebuf.YResolution,modebuf.BytesPerLine);
    return;
}
void main(void)
{
    long t=0;
    UV_install(".\\",0,0);
    printf("VESA 2.00 Kit v2.02\n");
    if (VBE_get_OEM_infos())
    {
	// Search for a 640x480x16bit mode
	mode = VBE_get_mode_by_infos(640,480,16);
	// Set the mode and enable LFB mode
	if (VBE_set_vesa_mode(mode))
	{
	    if (VESA.Linear)
	    {
		// Draw Directly in VRAM a Julia fractal
		t =clock();
		DrawJulia(32,500,-2.,2,-1,1,.777,.166);
		// Wait for a key
		t=clock()-t;
		getch();

	    }
	    set_vgamode(0x3);
	    if (t)
	    {
		printf("Delta = %d ms\n",(t*1000L)/CLK_TCK);
	    }
	}
	else
	{
	   set_vgamode(0x3);
	   printf("Cannot initialize mode %x\n",mode);
	   getch();
	}
    }
    Disp_VSystem();
    UV_exit();
    return;
}
