/*


                           MaLiCe VeSa LiBrARy 
                          
                                Include file
                            by MaLiCe / WitchCraft

                                 August 1998 


*/


#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include "vesa.h"



void main()
{

	VBESCREEN Screen,Virtual;
	short *modelist;
	short modenum;
	char lastmode;
	short j;
	
	
	puts ("\nMaLiCe VESA Library testing utility\n");
	printf ("Initializing VBE... ");
	
	// Init VBE
	if (vbeInit() != 0) {
		puts ("Could not find VBE 2.0. Driver not loaded?");
		exit(1);
	}
	puts ("OK");
	
	// Show video hardware info
	printf ("\nVBE version : %d.%d\n",VbeInfoBlock.VbeVersion>>8,VbeInfoBlock.VbeVersion&0xFF);
	printf ("OEM string  : %s\n",VbeInfoBlock.OemStringPtr);
	printf ("Total mem   : %dK\n",VbeInfoBlock.TotalMemory*64);
	printf ("\nOEM software rev : %d.%d\n",VbeInfoBlock.OemSoftwareRev>>8,VbeInfoBlock.OemSoftwareRev&0xFF);
	printf ("OEM vendor name  : %s\n",VbeInfoBlock.OemVendorNamePtr);
	printf ("OEM product name : %s\n",VbeInfoBlock.OemProductNamePtr);
	
	// Show supported video modes
	puts ("\nPress a key to show a list of supported modes...\n");getch();
	modelist = VbeInfoBlock.VideoModePtr;
	while (*modelist != -1) {
		if (vbeGetModeInfo(*modelist) == 0) {
			printf ("%3xh : %4d x %4d x %2dbpp", *modelist,
					ModeInfoBlock.XResolution,
					ModeInfoBlock.YResolution,
					ModeInfoBlock.BitsPerPixel);
			if (ModeInfoBlock.MemoryModel == 6)	//Direct Color Mode
				printf ("   (%d:%d:%d:%d)",
					ModeInfoBlock.RsvdMaskSize,
					ModeInfoBlock.BlueMaskSize,
					ModeInfoBlock.GreenMaskSize,
					ModeInfoBlock.RedMaskSize);
			printf("\n");
		}
		modelist++;
	}
	
	// Test one of the modes
	printf ("\nSelect a mode: "); scanf ("%x",&modenum);
	vbeGetModeInfo(modenum);
	lastmode = vbeGetVGAMode();				//Save last mode
	if (vbeSetMode (ModeInfoBlock.XResolution, ModeInfoBlock.YResolution,
				ModeInfoBlock.BitsPerPixel, &Screen) == 4) {
			puts ("Mode not supported"); exit(0); }
	vbeSetVGAMode (lastmode);
	
	// Show video mode info
	puts ("Last mode information:\n");
	printf ("x resolution : %d\ny resolution : %d\nLFB address  : %x\nsize (bytes) : %d\n",
			Screen.xres, Screen.yres, Screen.adr, Screen.size);
	
	
	// Test virtual screens
	if (vbeSetVirtual (Screen.xres,Screen.yres,&Virtual) == 0) {
		puts ("\nAllocated virtual screen:\n");
		printf ("x resolution : %d\ny resolution : %d\naddress      : %x\nsize (bytes) : %d\n",
				Virtual.xres, Virtual.yres, Virtual.adr, Virtual.size);
		
		// Test screen flipping
		puts ("\nPress a key to test flipping... "); getch();
		vbeSetMode (ModeInfoBlock.XResolution, ModeInfoBlock.YResolution,
					ModeInfoBlock.BitsPerPixel, &Screen);
		vbeFlip (&Virtual,&Screen);
		getch();
		
		// Test scrolling
		for (j=0; j<=ModeInfoBlock.YResolution; j+=2) {
			vbeWR();
			vbeSetStart (0,j);
		}
		
		vbeSetVGAMode (lastmode);
		puts ("Screen flipping succesful");
		if (vbeFreeVirtual(&Virtual)==0)
			puts ("Virtual screen deallocated correctly");
		}
	puts ("\nEnd of test\n");
}