#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <conio.h>
#include <string.h>
#include <mem.h>
#include <dos.h>
#include <math.h>
#include "command.h"

extern union REGS r;
struct SREGS segregs;
extern FILE *in, *out;
extern int DrawTo;
extern int num_obj;
extern char page;
int Draw_it=TRUE;

/********************
*  OBJECT POINTERS  *
*********************/
extern char far *object[2000];             // POINTER TO OBJECT BLOCKS
extern char far *color_blk;                // COLOR BLOCK
extern char far *obj;                      // OBJECT POINTER
extern char far *ptr;

union REGS r;
int StartUpheight;
int StartUpmode;

extern int PAGE0;
extern int PAGE1;
extern int PAGEINC_0;
extern int PAGEINC_1;
extern int SCRN_HEIGHT;
extern int SCRN_WIDTH;
extern int START_BACKGROUND;
extern int VisiblePageOffs, Page1_Offs;

void Flip (void)
{
	if (page) {
		FlipPage(0,0);
		page=0;
		DrawTo=Page1_Offs;
	}
	else {
		FlipPage (0,SCRN_HEIGHT);
		page=1;
		DrawTo=0;
	}
}

char SetMode (void)
{
    union REGS r;               // SAVE ENTRY STATUS OF TEXT MODE
    r.x.dx=0;
	r.x.cx=0;
	r.x.bx=0;
    r.h.ah=0x11;
    r.h.al=0x30;
    int86 (0x10, &r, &r);

    StartUpheight = r.x.cx;     // GET CURSOR HEIGHT

    r.h.ah=0xf;
    int86(0x10,&r,&r);
    StartUpmode=r.h.al;         // GET ENTRY GRAPHIC MODE

    PAGE0=0;
    PAGEINC_0=0;
    SetModeX (0,320);
    Page1_Offs=16000;
    SCRN_HEIGHT=200;
    SCRN_WIDTH=320;
    return TRUE;
}

/**********************************
*  PREPARE SCREEN BEFORE EXITING  *
***********************************/
void escape (void)
{
    union REGS r;
    mode (StartUpmode);         // RETURN TO ENTRY STATUS OF TEXT MODE
    r.x.ax = (StartUpheight==8) ? 0x1112: 0x1114;
    r.h.bl = 0;
    int86 (0x10, &r, &r);
}
void mode (int mode_code)
{
    r.h.al=mode_code;
    r.h.ah=0;
    int86(0x10,&r,&r);
}
void LoadObjects(char *open_file, char far *object[], char far *obj_ptr)
{
    FILE *in;
    char far *ptr_obj;

    unsigned char x,x_len,y_len;
    ptr_obj=obj_ptr;
    if ((in = fopen (open_file,"rb"))==NULL) {
		escape();
		printf ("Object File %s not found.\n",open_file);
		exit (1);
    }

    num_obj=fgetc(in);
    while (!feof(in))
        *(ptr_obj++) = (unsigned char) fgetc(in);
    fclose (in);

    ptr_obj=obj_ptr;                    // PARSE OBJECT TABLE AND
    for (x=0; x<num_obj; x++) {         // PLACE IN POINTER ARRAY
        object[x]=ptr_obj;
        x_len=*(ptr_obj++)<<2;
        y_len=*(ptr_obj++);
        ptr_obj=ptr_obj+(x_len*y_len);
    }
}
/*************************
*  LOAD COLOR PALETTE    *
**************************/
void LoadPalette (char *open_file)
{
	FILE *in;
    register int y;

    if ((in = fopen (open_file,"rb"))==NULL) {
		escape();
		printf ("Palette File (%s) not found.\n", open_file);
		exit (1);
    }
    for (y=0; y<768; y++)
		*(color_blk+y) = (unsigned char) fgetc(in);
    fclose (in);
}
/***************************
*  ROUTINE TO SET PALETTE  *
****************************/
void SetPalette (char far *palette)
{
    r.h.ah = 0x10;
    r.h.al = 0x12;
    r.x.bx = 0;
    r.x.cx = 256;
	r.x.dx = FP_OFF (palette);
    segregs.es  = FP_SEG (palette);
    int86x (0x10,&r,&r,&segregs);
}
