#include    <stdio.h>
#include    <conio.h>
#include    <string.h>
#include    <dos.h>
#include    "video.h"

#define FLI_COLOR       11  // be not used this flc player cos gerneral flc,fli
#define FLI_BLACK       13  // files donot use this type of chunk
#define FLI_COPY        16  //

#define FLI_LC          12
#define FLI_BRUN        15
#define FLI_DELTA       7
#define FLI_256_COLOR   4
#define FLI_MINI        18

void    main(int argc, char *argv[])
{
    struct  {
        long    size;       // length of file
        short   magic;
        short   frame, width, height, depth, flags, speed;
        long    next, frit;
        char    expand[102];
    }   Header ;

    FILE    *fp;

    if (argc<2) {
        printf("FLCTEST <filename>\n");
        return;
    }

    fp = fopen(argv[1], "rb");
    if (fp == NULL) return;

    fread(&Header, 1, sizeof(Header), fp);

    {
        struct  {
            int     width, height;
            short   mode;
        }   Vesa[5] = {
            320, 200, 0x13,
            640, 400, 0x100,
            640, 480, 0x101,
            800, 600, 0x103,
            1024, 768, 0x105
        };

        for(int i=0; i<5; i++)
            if (Vesa[i].width >= Header.width && Vesa[i].height >= Header.height)
                break;

        InitVideo(Vesa[i].mode);
    }

    char    *video = new char [Header.width * Header.height];
    char    *palette = new char [256*3];

    for(int frame=0; frame<Header.frame; frame++) {

        struct  {
            long    size;
            unsigned short   magic, chunknum;
            char    null[8];
        }   header;

        fread(&header, 1, sizeof(header), fp);

        if (header.magic != 0xf1fa) {
            // FLC's info data for only Autodesk Animator Pro
            // Skip this frame ( and subtract total frames this )
            fseek(fp, header.size-sizeof(header), SEEK_CUR);
            Header.frame --;
            frame --;
            continue;
        }

        int     next = ftell(fp) + header.size - sizeof(header);

        for(; header.chunknum>0; header.chunknum--) {
            struct  {
                long    size;
                short   type;
            }   chunk;

            fread(&chunk, 1, sizeof(chunk), fp);

            switch(chunk.type) {
                case FLI_COLOR : {
                    short   num = 0;
                    fread(&num, 1, 2, fp);

                    for(; num>0; num--) {
                        short   skipbyte = fgetc(fp);
                        short   putbyte = fgetc(fp);

                        if (putbyte == 0) putbyte = 256;

                        fread(palette + skipbyte*3, 3, putbyte, fp);
                        for(int i=0; i<putbyte*3; i++)  palette[i+skipbyte*3] *= 4;
                    }
                    SetPalette(palette);
                }   break;

                case FLI_256_COLOR : {
                    short   num = 0;
                    fread(&num, 1, 2, fp);

                    for(; num>0; num--) {
                        short   skipbyte = fgetc(fp);
                        short   putbyte = fgetc(fp);

                        if (putbyte == 0) putbyte = 256;

                        fread(palette + skipbyte*3, 3, putbyte, fp);
                    }
                    SetPalette(palette);
                }   break;

                case FLI_LC : {
                    short   skipline, putline;

                    fread(&skipline, 1, 2, fp);
                    fread(&putline, 1, 2, fp);

                    for(; putline>0; putline--, skipline++) {
                        int     offset = skipline * Header.width;
                        char    num = fgetc(fp);
                        for(; num>0; num--) {
                            char    skipbyte = fgetc(fp);
                            signed char putbyte = fgetc(fp);

                            offset += skipbyte;

                            if (putbyte<0) {
                                memset(video + offset, fgetc(fp), -putbyte);
                                offset -= putbyte;
                            } else {
                                fread(video+offset, 1, putbyte, fp);
                                offset += putbyte;
                            }
                        }
                    }
                }   break;

                case FLI_DELTA : {
                    short   putline;

                    fread(&putline, 1, 2, fp);

                    for(int y=0; putline>0; ) {
                        short   num = 0;
                        fread(&num, 1, 2, fp);

                        if (num > 0) {
                            int     offset = y * Header.width;

                            for(; num>0; num--) {
                                char    skipbyte = fgetc(fp);
                                short   putbyte = (signed char)fgetc(fp) * 2;

                                offset += skipbyte;

                                if (putbyte >= 0) {
                                    fread(video+offset, 1, putbyte, fp);
                                    offset += putbyte;
                                } else {
                                    fgetc(fp);
                                    memset(video+offset, fgetc(fp), -putbyte);
                                    offset -= putbyte;
                                }
                            }
                            y++;
                            putline--;
                        } else {
                            y-=num;
                        }
                    }
                }   break;

                case FLI_BRUN : {
                    for(int j=0, offset=0; j<Header.height; j++) {
                        for(char num = fgetc(fp); num>0; num--) {
                            signed char putbyte = fgetc(fp);

                            if (putbyte<0) {
                                fread(video+offset, 1, -putbyte, fp);
                                offset -= putbyte;
                            } else {
                                memset(video+offset, fgetc(fp), putbyte);
                                offset += putbyte;
                            }
                        }
                    }
                }   break;

                default :
                    //  Skip this chunk
                    fseek(fp, chunk.size-sizeof(chunk), SEEK_CUR);
                    break;
            }
        }

        fseek(fp, next, SEEK_SET);

        PutImage((SCREEN_XSIZE-Header.width)/2, (SCREEN_YSIZE-Header.height)/2,
            video, Header.width, Header.height);

        if(getch()==27) break;  // if ESC is pressed, quit
    }
    fclose(fp);

    UninitVideo();

    printf("width = %d\nheight = %d\n%d frames\n", Header.width, Header.height, Header.frame);
}
