// PCX2CSRC.CPP
// Converts bitmap and palette data from a PCX file into C++ source code
// coded by Tumblin / Bodies In Motion


#include  <process.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<dos.h>
#include	"pcx.h"


FILE *fp;
char source_filename[80];
char target_filename[80];

pcx_struct pcxbuf;  // Buffer for PCX data
Pcx pcxloader;      // PCX loader object
int width, height;	// width and height in pixels
int top_left_x,top_left_y,bottom_right_x,bottom_right_y;
char which_mode;	// X = Mode-X bitmap, L = linear mode 13h bitmap


void WriteBitmapXData(void);	// Mode-X
void WriteBitmapLData(void);	// Mode 13h
void WritePaletteData(void);


void main()
{
	// greet the user and ask for information
	printf("                    Ŀ\n");
	printf("                     PCX to C++ Source Code Converter \n");
	printf("                     for use with PCX files and XLIB  \n");
	printf("                      by Tumblin / Bodies In Motion   \n");
	printf("                    \n\n\n");

	printf("Enter the filename of the source PCX file\n");
	printf("(filename.ext) : ");
	scanf("%s",&source_filename);

	printf("\nEnter the filename of the target source code file\n");
	printf("(filename.ext) : ");
	scanf("%s",&target_filename);

	printf("\nDo you want to do a Mode-X planar bitmap or Linear bitmap?\n");
	printf("[X/L] : ");
	which_mode=getche();
	if(which_mode=='x' || which_mode=='X')
	{
		which_mode='X';
		printf("\n\nNote you must make sure that the width of your bitmap is\n");
		printf("divisible by four.\n\n");
	}

	if(which_mode=='y' || which_mode=='Y')
		which_mode='Y';

	printf("\n\nEnter top left X coordinate of bitmap : ");
	scanf("%i",&top_left_x);

	printf("\nEnter top left Y coordinate of bitmap : ");
	scanf("%i",&top_left_y);

	printf("\nEnter bottom right X coordinate of bitmap : ");
	scanf("%i",&bottom_right_x);

	printf("\nEnter bottom right Y coordinate of bitmap : ");
	scanf("%i",&bottom_right_y);


	if (pcxloader.load(source_filename,&pcxbuf))
	{
		puts("Sorry but couldn't load PCX file.\n");     // Can't open it?
		exit(0);                             // Abort w/error
	}

	// open target source code file
	fp=fopen(target_filename,"w");
	if(!fp)
	{
		printf("\nSorry but I couldn't open the target file.");
		exit(1);
	}


	// Generate appropriate bitmap data
	if(which_mode=='X')
		WriteBitmapXData();
	else
		WriteBitmapLData();

	// Generate appropriate palette data
	WritePaletteData();


	// all done, exit
	fclose(fp);
}


void WriteBitmapXData(void)
{
	int p;
	int height=bottom_right_y-top_left_y+1;
	int width=bottom_right_x-top_left_x+1;

	fprintf(fp,"// This is a Mode-X Planar Bitmap\n");
	fprintf(fp,"char name_of_bitmap[] =\n{\n");
	fprintf(fp,"  %3i,  // width in bytes (4 pixel groups)\n",width/4);
	fprintf(fp,"  %3i,  // height in pixels\n\n  ",height);

	// write data for planes 0 to 2
	for(p=0; p<3; p++)
	{
		fprintf(fp,"// plane %d\n  ",p);
		for(int y=top_left_y; y <= bottom_right_y; y++)
		{
			for(int x=top_left_x+p; x <= bottom_right_x; x+=4)
			{
				if((int)pcxbuf.image[y*320+x] < 0)
					fprintf(fp,"%3i,",(int)pcxbuf.image[y*320+x]+256);
				else
					fprintf(fp,"%3i,",(unsigned int)pcxbuf.image[y*320+x]);
			}
			fprintf(fp,"\n  ");
		}
	}
	fprintf(fp,"// plane %d\n  ",p);

	// write data for plane 3 but don't do the last line
	for(int y=top_left_y; y < bottom_right_y; y++)
	{
		for(int x=top_left_x+p; x <= bottom_right_x; x+=4)
			if((int)pcxbuf.image[y*320+x] < 0)
				fprintf(fp,"%3i,",(int)pcxbuf.image[y*320+x]+256);
			else
			fprintf(fp,"%3i,",(unsigned int)pcxbuf.image[y*320+x]);
	fprintf(fp,"\n  ");
	}

	// write data for last line of plane 3 but not the last pixel
	for(int x=top_left_x+p; x < bottom_right_x; x+=4)
	{
		if((int)pcxbuf.image[height*320+x] < 0)
			fprintf(fp,"%3i,",(int)pcxbuf.image[bottom_right_y*320+x]+256);
		else
			fprintf(fp,"%3i,",(unsigned int)pcxbuf.image[bottom_right_y*320+x]);
	}

	// write the data for the last pixel of the last line of plane 3
	if((int)pcxbuf.image[bottom_right_y*320+bottom_right_x] < 0)
		fprintf(fp,"%3i",(int)pcxbuf.image[bottom_right_y*320+bottom_right_x]+256);
	else
		fprintf(fp,"%3i",(unsigned int)pcxbuf.image[bottom_right_y*320+bottom_right_x]);

	// write the final "};"
	fprintf(fp,"\n};\n\n\n");
}


void WriteBitmapLData(void)
{
	int x,y;

	width=bottom_right_x-top_left_x+1;
	height=bottom_right_y-top_left_y+1;

	fprintf(fp,"// This is a linear Mode 13h Bitmap\n");
	fprintf(fp,"char name_of_bitmap[] =\n{\n");
	fprintf(fp,"  %3i,	// width in pixels\n",width);
	fprintf(fp,"  %3i,	// height in pixels\n",height);


	// write data for bitmap but not last line
	for(y=top_left_y; y<bottom_right_y; y++)
	{
		fprintf(fp,"\n  ");
		for(x=top_left_x; x<=bottom_right_x; x++)
		{
			if((int)pcxbuf.image[y*320+x] < 0)
				fprintf(fp,"%3i,",(int)pcxbuf.image[y*320+x]+256);
			else
				fprintf(fp,"%3i,",(unsigned int)pcxbuf.image[y*320+x]);
		}
	}

	fprintf(fp,"\n  ");

	// write data for last line of bitmap but not last pixel
	for(x=top_left_x; x<bottom_right_x; x++)
	{
		if((int)pcxbuf.image[bottom_right_y*320+x] < 0)
			fprintf(fp,"%3i,",(int)pcxbuf.image[bottom_right_y*320+x]+256);
		else
			fprintf(fp,"%3i,",(unsigned int)pcxbuf.image[bottom_right_y*320+x]);
	}

	// write data for last pixel of last line
	if((int)pcxbuf.image[bottom_right_y*320+bottom_right_x] < 0)
		fprintf(fp,"%3i",(int)pcxbuf.image[bottom_right_y*320+bottom_right_x]+256);
	else
		fprintf(fp,"%3i",(unsigned int)pcxbuf.image[bottom_right_y*320+bottom_right_x]);

	// write the final "};"
	fprintf(fp,"\n};\n\n\n");
}


void WritePaletteData(void)
{
	// write the source code for the palette data
	fprintf(fp,"// This is palette data\n");
	fprintf(fp,"char name_of_palette[3*256]=\n{");

	// write data for all colors in palette but not last one
	for(int y=0; y<255; y++)
	{
		fprintf(fp,"\n  %2i,%2i,%2i, // color # %i",pcxbuf.palette[y*3],pcxbuf.palette[y*3+1],pcxbuf.palette[y*3+2],y);
	}

	// write data for last color in palette
	fprintf(fp,"\n  %2i,%2i,%2i  // color # 255",pcxbuf.palette[y*3],pcxbuf.palette[y*3+1],pcxbuf.palette[y*3+2]);

	// write the final "};"
	fprintf(fp,"\n};");
}
