/* demo2.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

/* this demo shows how to load a .jlb,  use an offscreen buffer and perform
** vertical scrolling useing the library.
*/

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

int main(void)
{
 int i,x;
 image *jlb_pic;
 buffer_rec *offscreen;

 /* init buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* check that initialisation was OK */
 if(offscreen == NULL){
    printf("ERROR:could not initialise buffer.\n");
    exit(0);
 }

 /* load jlb */
 jlb_pic = image_load_jlb("demo2.jlb");

 /* check that load was OK */
 if(jlb_pic == NULL){
    printf("ERROR:could not load image file.\n");
    exit(0);
 }

 /* set mode and palette */
 screen_set_video_mode(); 


 screen_block_set_pal(IMG_PALETTE(jlb_pic));
 
 /* put image into offscreen buffer */
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,IMG_WIDTH(jlb_pic),IMG_HEIGHT(jlb_pic));

 x=500;
    
 /* do scrolling by moving through the offscreen buffer */
 do{
   for(i=0;i<50;i++){
       screen_blit_buff_toNC(0,0,offscreen,0,i,IMG_WIDTH(jlb_pic),i+150);
   }
   
   for(i=50;i>0;i--){
       screen_blit_buff_toNC(0,0,offscreen,0,i,IMG_WIDTH(jlb_pic),i+150);
   }

 }while(x--);

 /* return to text mode and exit */
 screen_restore_video_mode();

 return 0;
}
