/* demo4.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

#define COLOR 100

int main(void)
{
 int xpos,ypos,buttons;
 USHORT stx,sty,edx,edy;
 image *jlb_pic;
 buffer_rec *offscreen;

 if(!MOUSE_AVAILABLE){
    printf("ERROR: No mouse support.\n");
    exit(-1);
 }

 /* initialise screen sized buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* check that initialisation was OK */
 if(offscreen == NULL){
    printf("ERROR:could not initialise buffer.\n");
    printf("press any key to exit.\n");
    exit(0);
 }

 /* load jlb */
 jlb_pic = image_load_jlb("demo4.jlb");

 /* check that load was OK */
 if(jlb_pic == NULL){
    printf("ERROR:could not load image file.\n");
    printf("press any key to exit.\n");
    exit(0);
 }

 /* set up the screen */
 screen_set_video_mode();
 screen_set_page(1);
 screen_show_page(1);

 if(!mouse_present()){
    screen_restore_video_mode();
    printf("ERROR: No mouse installed.\n");
    exit(-1);
 }

 screen_block_set_pal(IMG_PALETTE(jlb_pic));

 /* copy the image to the offscreen buffer */
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,B_X_SIZE(jlb_pic),B_Y_SIZE(jlb_pic));

 /* show buffer and turn on mouse pointer */
 screen_blit_fs_buffer(offscreen);
 mouse_show_pointer();

 /* this loop draws lines from the position the mouse is at when the 
    buttons are pressed.                                             */
 do{
    mouse_get_status(&xpos,&ypos,&buttons);
    if(BUTTON_DOWN(buttons)){
       stx=xpos;
       sty=ypos;
       do{
	 mouse_get_status(&xpos,&ypos,&buttons);
	 if(!BUTTON_DOWN(buttons)){
	    edx=xpos;
	    edy=ypos;
	    mouse_hide_pointer();
	    buff_draw_line(offscreen,stx,sty,edx,edy,COLOR);
	    screen_blit_fs_buffer(offscreen);
	    mouse_show_pointer();
	    break;
	 }
       }while(1);
    }
 }while(1);

 /* wait for a key press, hide the pointer, re-blit the screen & show pointer */

 mouse_hide_pointer();
 
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,B_X_SIZE(jlb_pic),B_Y_SIZE(jlb_pic));
 screen_blit_fs_buffer(offscreen);


 /* this loop draws boxes from the position the mouse is at when the left  **
 ** buttons are pressed.                                                   */
 mouse_show_pointer();

 do{
    mouse_get_status(&xpos,&ypos,&buttons);
    if(BUTTON_DOWN(buttons)){
       stx=xpos;
       sty=ypos;
       do{
	 mouse_get_status(&xpos,&ypos,&buttons);
	 if(!BUTTON_DOWN(buttons)){
	    edx=xpos;
	    edy=ypos;

	    mouse_hide_pointer();
	    buff_draw_box(offscreen,stx,sty,edx,edy,100);
	    screen_blit_fs_buffer(offscreen);
	    mouse_show_pointer();
	    break;
	 }
       }while(1);
    }
 }while(1);

 /* set text mode and exit */
 screen_restore_video_mode();
 
 return(1);
}
