/* demo7.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

#include <jlib.h>

/* this demo just draws some text on the screen. */


#define COL(x)   ((x)*CHAR_WIDTH('a'))
#define LINE(x)  ((x)*CHAR_HEIGHT('a'))
#define TEXT_COL 15

int main(void)
{
 UBYTE c;
 buffer_rec *offscreen;

 offscreen=buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 screen_set_video_mode();
 screen_set_page(1);
 screen_show_page(1);
 screen_put_pal(TEXT_COL,255,255,255);

 for(c=32;c<32+80;c++){
     buff_draw_char(offscreen,c,COL(c-32),LINE(2),TEXT_COL);
 }

 for(c=32+80;c<128;c++){
     buff_draw_char(offscreen,c,COL(c-80-32),LINE(3),TEXT_COL);
 }

 buff_draw_string(offscreen,"Welcome to a new and wonderful font.",COL(5),LINE(5),TEXT_COL);
 buff_draw_string(offscreen,"I hope you enjoy looking at it,",COL(5),LINE(6),TEXT_COL);
 buff_draw_string(offscreen,"Because it's the only one there is!",COL(5),LINE(7),TEXT_COL);
 buff_draw_string(offscreen,"main()",COL(5),LINE(8),TEXT_COL);
 buff_draw_string(offscreen,"  int i,j,screen_pos;",COL(5),LINE(9),TEXT_COL);
 buff_draw_string(offscreen,"  screen_draw_stringNC(); ",COL(5),LINE(10),TEXT_COL);

 screen_blit_fs_buffer(offscreen);

 fgetc(stdin);
   
 screen_restore_video_mode();
 return(1);
}



