/* iotest.c - test some of the device independent IO functions */

#include <jlib.h>
#include <stdio.h>
#include "jio.h"

int main(void)
{
 UBYTE c;
 USHORT u;
 _J_32_BIT a; /* You should NOT use _J_32_BIT in your progs!!! */
 FILE *fp;

 /* write some known values to an output file */
 fp = fopen("testout","wb");

 fputc(1,fp);
 fputc(2,fp);
 fputc(3,fp);
 fputc(4,fp);
 fputc(5,fp);
 fputc(6,fp);
 fputc(7,fp);

 fclose(fp);


 /* open it and try to read them in */
 fp = fopen("testout","rb");

  /* test char */ 
  jio_read_elementary_type(fp,&c,sizeof(UBYTE));

  if(c != 1){
    puts("failed.");
    fclose(fp);
    exit(-1);
  }
  puts("char read ok");
 
 /* test short */
 jio_read_elementary_type(fp,(UBYTE *)&u,sizeof(USHORT));

  if(u != ((3*256)+2)){
    puts("failed.");
    fclose(fp);
    exit(-1);
  }
  puts("short read ok");
 
 /* test int */
 jio_read_elementary_type(fp,(UBYTE *)&a,sizeof(a));

  if(a != ((7<<24)+(6<<16)+(5<<8)+4)){
    puts("failed.");
    fclose(fp);
    exit(-1);
  }
  puts("int read ok");

 puts("Input seems OK...");
 fclose(fp); 


 /* write some more values to the output file */
 fp = fopen("testout","wb");

 c = 200;

 if(jio_write_elementary_type(fp,&c,sizeof(UBYTE))==1){
    puts("CHAR write appears ok");
 }
 else{
    puts("Failed.");
    fclose(fp);
    exit(-1);
 }

 u = 1500;

 if(jio_write_elementary_type(fp,&u,sizeof(USHORT))==1){
    puts("SHORT write appears ok");
 }
 else{
    puts("Failed.");
    fclose(fp);
    exit(-1);
 }

 a = 356000;

 if(jio_write_elementary_type(fp,&a,sizeof(a))==1){
    puts("int write appears ok");
 }
 else{
    puts("Failed.");
    fclose(fp);
    exit(-1);
 }

 fclose(fp); 


 /* make sure they were written correctly */
 /* open it and try to read them in */
 fp = fopen("testout","rb");

 /* test char */ 
 jio_read_elementary_type(fp,&c,sizeof(UBYTE));

 if(c != 200){
   puts("failed.");
   fclose(fp);
   exit(-1);
 }
 puts("char read ok");
 
 /* test short */
 jio_read_elementary_type(fp,(UBYTE *)&u,sizeof(USHORT));

 if(u != 1500){
   puts("failed.");
   fclose(fp);
   exit(-1);
 }
 puts("short read ok");
 
 /* test int */
 jio_read_elementary_type(fp,(UBYTE *)&a,sizeof(a));

 if(a != 356000){
   puts("failed.");
   fclose(fp);
   exit(-1);
 }
 puts("int read ok");


 puts("Output seems OK...");
 fclose(fp); 

 /* delete output file */
 unlink("testout");

 exit(0);
}  
 
 
