/* maketrig.c - trig table functions */
#include <math.h>
#include <stdlib.h>
#include "maketrig.h"

#ifndef NULL
 #define NULL 0L
#endif

/****************************************************************************/
int *create_sin_table(int num_divs)
{
 double rad_angle,curr_angle;
 int rad_count;
 int *temp_table;

 /* check for sensible number of circle divisions ( 1 - 4096) */
 if((num_divs<1)||(num_divs>4096)){
    exit(0);
 }

 /* create an array to hold the table */
 if((temp_table = (int *)malloc(sizeof(int)*num_divs))==NULL){
    exit(0);
 }

 rad_angle = (PI + PI)/num_divs;
 curr_angle = 0;

 for(rad_count=0;rad_count<num_divs;rad_count++){
     temp_table[rad_count] = (int)(sin(curr_angle)*SCALE_FACTOR);
     curr_angle += rad_angle;
 }

 return temp_table;
}


/****************************************************************************/
int *create_cos_table(int num_divs)
{
 double rad_angle,curr_angle;
 int rad_count;
 int *temp_table;

 /* check for sensible number of circle divisions ( 1 - 4096) */
 if((num_divs<1)||(num_divs>4096)){
    exit(0);
 }

 /* create an array to hold the table */
 if((temp_table = (int *)malloc(sizeof(int)*num_divs))==NULL){
    exit(0);
 }

 rad_angle = (PI + PI)/num_divs;

 curr_angle = 0;

 for(rad_count=0;rad_count<num_divs;rad_count++){
     temp_table[rad_count] = (int)(cos(curr_angle)*SCALE_FACTOR);
     curr_angle += rad_angle;
 }

 return temp_table;
}


/****************************************************************************/
int *destroy_trig_table(int *table)
{
 free(table);

 return (int*)NULL;
}
