
/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */
#include <string.h>
#include <jlib.h>

#define ABS(a)   ((a < 0) ? -a : a)
#define SGN(a)   ((a < 0) ? -1 : 1)

#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

#define jclipline(x1,y1,x2,y2)                                         \
{                                                                      \
int temp;                                                              \
								       \
  if(x1 > x2){                                                         \
    _SWAP(x1,x2);                                                       \
    _SWAP(y1,y2);                                                       \
  }                                                                    \
								       \
  if(x1 > SCREEN_WIDTH){                                               \
     return;                                                           \
  }                                                                    \
								       \
  if(y1 < y2) {                                                        \
     if(y1 > SCREEN_HEIGHT){                                           \
	return;                                                        \
     }                                                                 \
								       \
     if(y2 > SCREEN_HEIGHT){                                           \
	temp = (x2 - x1)*(y2 - SCREEN_HEIGHT)/(y2 - y1);               \
								       \
	if((x2 -= temp) > SCREEN_WIDTH) {                              \
	   return;                                                     \
	}                                                              \
								       \
	y2 = SCREEN_HEIGHT;                                            \
      }                                                                \
								       \
      if(x2 > SCREEN_WIDTH){                                           \
	 temp = (y2 - y1)*(x2 - SCREEN_WIDTH)/(x2 - x1);               \
								       \
	 y2 -= temp;                                                   \
	 x2 = SCREEN_WIDTH;                                            \
      }                                                                \
								       \
  }                                                                    \
  else{                                                                \
      if(y2 > SCREEN_HEIGHT){                                          \
	 return;                                                       \
      }                                                                \
								       \
      if(y1 > SCREEN_HEIGHT) {                                         \
	 temp=(x2 - x1)*(y1 - SCREEN_HEIGHT)/(y1 - y2);                \
								       \
	 if((x1 += temp) > SCREEN_WIDTH){                              \
	    return;                                                    \
	 }                                                             \
								       \
	 y1 = SCREEN_HEIGHT;                                           \
      }                                                                \
								       \
      if(x2 > SCREEN_WIDTH) {                                          \
	 temp=(y1 - y2)*(x2 - SCREEN_WIDTH)/(x2 - x1);                 \
								       \
	 y2 += temp;                                                   \
	 x2 = SCREEN_WIDTH;                                            \
	}                                                              \
    }                                                                  \
}



/*+-------------------------------------------------------------------------+ */
/*|draw a line from x1, y1 to x2, y2 in color c                             | */
/*|                                                                         | */
/*+-------------------------------------------------------------------------+ */

void buff_draw_line (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c)
{
   int d, x, y, ax, ay, sx, sy, dx, dy;
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width = B_X_SIZE (buff);
   USHORT height = B_Y_SIZE (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_line()\n");

   /* clip the points */
   jclipline(x1,y1,x2,y2);
   
   dx = x2 - x1;
   ax = ABS (dx) << 1;
   sx = SGN (dx);
   dy = y2 - y1;
   ay = ABS (dy) << 1;
   sy = SGN (dy);

   x = x1;
   y = y1;

   if (ax > ay) {
      d = ay - (ax >> 1);
      while (x != x2) {
	 buffer[((unsigned int)width * y) + x] = c;
	 if (d >= 0) {
	    y += sy;
	    d -= ax;
	 }
	 x += sx;
	 d += ay;
      }
   }
   else {
      d = ax - (ay >> 1);
      while (y != y2) {
	 buffer[(unsigned int)(width * y) + x] = c;
	 if (d >= 0) {
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_line()\n");
}

/*+-------------------------------------------------------------------------+ */
/*|draw a line from x1, y1 to x2, y2 in color c                             | */
/*+-------------------------------------------------------------------------+ */

void buff_draw_lineNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c)
{
   int d, x, y, ax, ay, sx, sy, dx, dy;
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width = B_X_SIZE (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_line_NC()\n");

   dx = x2 - x1;
   ax = ABS (dx) << 1;
   sx = SGN (dx);
   dy = y2 - y1;
   ay = ABS (dy) << 1;
   sy = SGN (dy);

   x = x1;
   y = y1;

   if (ax > ay) {
      d = ay - (ax >> 1);
      while (x != x2) {
	 buffer[(unsigned int)(width * y) + x] = c;
	 if (d >= 0) {
	    y += sy;
	    d -= ax;
	 }
	 x += sx;
	 d += ay;
      }
   }
   else {
      d = ax - (ay >> 1);
      while (y != y2) {
	 buffer[(unsigned int)(width * y) + x] = c;
	 if (d >= 0) {
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_line_NC()\n");
}


/*+------------------------------------------------------------------------+ */
/*|draw a horizontal line from x1, y1 to x2 in color c with clipping       | */
/*+------------------------------------------------------------------------+ */

void buff_draw_h_line (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, UBYTE c)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width = B_X_SIZE (buff);
   USHORT height = B_Y_SIZE (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_h_line()\n");

   if (x1 > x2) {
      x2 ^= x1;
      x1 ^= x2;			/* swap ends around */
      x2 ^= x1;
   }

   /* clip points */
   if ((x1 >= width) || (y1 >= height)) {
      return;
   }

   if (x2 > width) {
      x2 = width;
   }

   buffer += ((unsigned int)width * (unsigned int)y1) + x1;
   memset (buffer, (int) c, (size_t) (x2 - x1) +1); /* +1 not a mistake */

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_h_line()\n");
}

/*+------------------------------------------------------------------------+ */
/*|draw a horizontal line from x1, y1 to x2 in color c without clipping    | */
/*+------------------------------------------------------------------------+ */

void buff_draw_h_lineNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, UBYTE c)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width = B_X_SIZE (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_h_line_NC()\n");

   if (x1 > x2) {
      x2 ^= x1;
      x1 ^= x2;			/* swap ends around */
      x2 ^= x1;
   }

   buffer += (width * y1) + x1;

   memset (buffer, (int) c, (size_t) (x2 - x1)+1 ); /* +1 not a mistake */

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_h_line_NC()\n");
}


/*+------------------------------------------------------------------------+ */
/*|draw a vertical line from x1, y1 to x2 in color c with clipping         | */
/*+------------------------------------------------------------------------+ */

void buff_draw_v_line (buffer_rec * buff, USHORT x1, USHORT y1, USHORT y2, UBYTE c)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width = B_X_SIZE (buff);
   USHORT height = B_Y_SIZE (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_v_line()\n");

   if (y1 > y2) {
      y2 ^= y1;
      y1 ^= y2;			/* swap ends around */
      y2 ^= y1;
   }

   /* clip coords if needed */
   if ((y1 > height) || (x1 > width)) {
      return;
   }

   if (y2 > height) {
      y2 = height;
   }

   buffer += ((unsigned int)width * (unsigned int)y1) + x1;

   for (; y2 == y1; y2--) {
      *buffer = c;
      buffer += width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_v_line()\n");
}


/*+------------------------------------------------------------------------+ */
/*|draw a vertical line from x1, y1 to x2 in color c without clipping      | */
/*+------------------------------------------------------------------------+ */

void buff_draw_v_lineNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT y2, UBYTE c)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width = B_X_SIZE (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_v_lineNC()\n");

   if (y1 > y2) {
      y2 ^= y1;
      y1 ^= y2;			/* swap ends around */
      y2 ^= y1;
   }

   buffer += ((unsigned int)width * (unsigned int)y1) + x1;

   for (; y2 == y1; y2--) {
      *buffer = c;
      buffer += width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_v_lineNC()\n");
}
