 
/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */
#include <stdlib.h>
#include <jlib.h>

#ifndef NULL
#define NULL 0L;
#endif


/*+------------------------------------------------------------------------+ */
/*|initialise an offscreen buffer                                          | */
/*+------------------------------------------------------------------------+ */

buffer_rec *buff_init (USHORT width, USHORT height)
{
   buffer_rec *tbrp;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_init()\n");

   /* allocate memory for the buffer record */
   if ((tbrp = (buffer_rec *) malloc (sizeof (buffer_rec))) == NULL) {
      return (buffer_rec *) NULL;
   }

   tbrp->width = width;
   tbrp->height = height;

   /* allocate memory for the buffer itself */
   if ((tbrp->buffer =
	(UBYTE *) malloc (B_SIZE (tbrp) * sizeof (UBYTE))) == NULL) {
      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at buff_init line %d\n", __LINE__);
      JLIB_PRINT_MESSAGE_STRING;

      return (buffer_rec *) NULL;
   }

   /* clear the buffer */
   memset (tbrp->buffer,0, B_SIZE (tbrp));

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_init()\n");

   /* return a handle */
   return tbrp;
}


/*+------------------------------------------------------------------------+ */
/*|clear a buffer by filling it with zeros.                                | */
/*+------------------------------------------------------------------------+ */

JINLINE void buff_clear (buffer_rec * buff)
{
   UBYTE *buffer = B_BUFF_PTR (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_clear()\n");

   memset (buffer, (int) 0, (size_t) B_X_SIZE (buff) * B_Y_SIZE (buff));

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_clear()\n");
}


/*+------------------------------------------------------------------------+ */
/*|fill the buff with a particular colour.                               | */
/*+------------------------------------------------------------------------+ */

JINLINE void buff_fill (buffer_rec * buff, int colour)
{
   UBYTE *buffer = B_BUFF_PTR (buff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_fill()\n");

   memset (buffer, colour, (size_t) B_X_SIZE (buff) * B_Y_SIZE (buff));

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_fill()\n");
}


/*+------------------------------------------------------------------------+ */
/*|free the storage used by a buffer to the OS.                            | */
/*+------------------------------------------------------------------------+ */

buffer_rec *buff_free (buffer_rec * buff)
{
   JLIB_PRINT_DEBUG_INFO ("Entering buff_free()\n");

   if (buff != NULL) {
      free (buff->buffer);

      free (buff);
   }

   return NULL;

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_free()\n");
}
