/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */

/* jconfig.h - Configuration defines for the library */

/* only include this file once */
#ifndef __JCONFIG_H__
#define __JCONFIG_H__

/* Target System:
   ** Only ONE target system should be defined.  Valid choices are:
   **
   ** DJGPP_DPMI_COMPLIANT - DJGPP V1 or V2 running under DOS, OS/2, WIN 3.1
   ** LINUX_SVGALIB        - Linux with SVGALIB 
   ** LINUX_GRX2           - Linux with libgrx version 2.
   ** X_WINDOWS            - Generic X server.
   ** GENERIC              - Use std lib functions and ignore screen stuff.
   **                        This option is provided as a porting aide.
   **
 */

#define DJGPP_DPMI_COMPLIANT


/* Target Graphics Mode:
   ** Only ONE target mode should be defined.  Valid choices are:
   **
   ** MODE_13H  - IBM-PC mode 13h,  320 x 200 x 256 colours.
   ** GRX_640x480x256 - 640 by 480 by 256 colors using libgrx (djgpp)
   **
   ** GRX2_320x200x256 - 320x200x256 for grx V2.
   ** GRX2_640x480x256 - 640x480x256 for grx V2.
   ** GRX2_800x600x256 - 800x600x256 for grx V2.
   ** 
   ** X_320x200x256 - 320 by 200 by 256 color window on an X server
   **
 */

#define MODE_13H



/* Inline keyword:
   ** Give the keyword your compiler uses to indicate that a function is to be
   ** inlined. (eg. inline __inline etc )
   **
 */

#define JINLINE inline


/* Debugging Information:
   ** Whether you want debugging information produced during program execution.
   **
   ** If JDEBUG is defined then debugging info will be printed.
   ** I'm probably the only person who will ever use this!
 */

/* #define JDEBUG */





/* Anything beyond this point you don't need to worry about unless you are a
** target writer (and we are few and far between!).
*/
#ifdef DJGPP_DPMI_COMPLIANT

#ifdef  GRX2_320x200x256 
#define GRX2_VARIANT
#endif
#ifdef  GRX2_640x480x256 
#define GRX2_VARIANT
#endif
#ifdef  GRX2_800x600x256 
#define GRX2_VARIANT
#endif

#endif /* djgpp dpmi */

#endif /* ifndef __JCONFIG_H__ */



