/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */

#include <jconfig.h>
#include <stdio.h>

/* jdebug.h - debugging functions */

/* this module must provide the following functions/macros:
   **
   ** JLIB_PRINT_DEBUG_INFO(x)  : print string x to screen,  file or wherever.
   ** JLIB_PRINT_MESSAGE_STRING : print the message string.
   **
   ** The string JLIB_MESSAGE_STRING is predeclared.  It has a max length  
   ** of 80 characters.  Debugging output can be sprintf'd to JLIB_MESSAGE_STRING
   ** and then printed using JLIB_PRINT_MESSAGE_STRING. JLIB_SPRINTF is defined
   ** to do this so that in non-debug executables all debug code is eliminated.
 */

#ifndef __JDEBUG_H__
#define __JDEBUG_H__

#ifdef __cplusplus
extern "C" {
#endif

static char JLIB_MESSAGE_STRING[81];	/* Global debugging message string */

#ifdef JDEBUG
#define JLIB_SPRINTF sprintf
#else
/* leaving out the function just leaves the args to evaluate & throw away -
 * hence no code is generated. 
 */
#define JLIB_SPRINTF
#endif /* ifdef JDEBUG */


/**************************************************************************/
#ifdef DJGPP_DPMI_COMPLIANT
/**************************************************************************/

#ifdef JDEBUG
#define JLIB_PRINT_DEBUG_INFO(x) printf(x);fflush(stdout)
#define JLIB_PRINT_MESSAGE_STRING printf(JLIB_MESSAGE_STRING);fflush(stdout)
#else
#define JLIB_PRINT_DEBUG_INFO(x)
#define JLIB_PRINT_MESSAGE_STRING
#endif /* ifdef JDEBUG */

#endif /* djgpp */


/**************************************************************************/
#ifdef LINUX_SVGALIB
/**************************************************************************/

#ifdef JDEBUG
#define JLIB_PRINT_DEBUG_INFO(x) printf(x);fflush(stdout)
#define JLIB_PRINT_MESSAGE_STRING printf(JLIB_MESSAGE_STRING);fflush(stdout)
#else
#define JLIB_PRINT_DEBUG_INFO(x)
#define JLIB_PRINT_MESSAGE_STRING
#endif /* ifdef JDEBUG */

#endif /* linux svgalib */

/**************************************************************************/
#ifdef LINUX_GRX2
/**************************************************************************/

#ifdef JDEBUG
#define JLIB_PRINT_DEBUG_INFO(x) printf(x);fflush(stdout)
#define JLIB_PRINT_MESSAGE_STRING printf(JLIB_MESSAGE_STRING);fflush(stdout)
#else
#define JLIB_PRINT_DEBUG_INFO(x)
#define JLIB_PRINT_MESSAGE_STRING
#endif /* ifdef JDEBUG */

#endif /* linux grx 2 */


/**************************************************************************/
#ifdef X_WINDOWS
/**************************************************************************/

/* the X target does not print debug info at this point in time */ 
#ifdef JDEBUG
#define JLIB_PRINT_DEBUG_INFO(x)
#define JLIB_PRINT_MESSAGE_STRING 
#else
#define JLIB_PRINT_DEBUG_INFO(x)
#define JLIB_PRINT_MESSAGE_STRING
#endif /* ifdef JDEBUG */

#endif /* X windows */


/**************************************************************************/
#ifdef GENERIC
/**************************************************************************/

#ifdef JDEBUG
#define JLIB_PRINT_DEBUG_INFO(x) printf(x);fflush(stdout)
#define JLIB_PRINT_MESSAGE_STRING printf(JLIB_MESSAGE_STRING);fflush(stdout)
#else
#define JLIB_PRINT_DEBUG_INFO(x)
#define JLIB_PRINT_MESSAGE_STRING
#endif /* ifdef JDEBUG */

#endif /* generic */

#ifdef __cplusplus
}
#endif /* cplusplus */

#endif /* ifndef __JDEBUG_H__ */
