/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */

#ifndef __JLIB_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <jconfig.h>
#include <jdebug.h>
#include <jtypes.h>
#include <jmemcopy.h>




/*+-----------------------------------------------------------------------+ */
/*|sprites - sprite functions                                             | */
/*+-----------------------------------------------------------------------+ */

/* return codes of function 'sprite_load' */
#define COULDNT_OPEN      1
#define TOO_MANY_IN_FILE  2
#define OUT_OF_MEMORY     3
#define SUCCESS           0

/* macros to get information about the sprite system */
#define SPR_MAX_X (64)		/* biggest possible sprite x */
#define SPR_MAX_Y (64)		/* biggest possible sprite y */
#define SPR_MAX_SPRITES(x) (x->no_sprites)
#define SPR_MAX_FRAMES(x) (x->no_frames)
#define SPR_NUM_LOADED(x) (x->number_loaded)

/* macros to get information about a sprite */
#define SPR_X_SIZE(spr_ptr) (spr_ptr->width)
#define SPR_Y_SIZE(spr_ptr) (spr_ptr->height)
#define SPR_IS_ON(spr_sys_ptr,spr_num) (spr_sys_ptr->active_sprites[(spr_num)])
#define SPR_GET_XPOS(sys,snum)   (sys->sprites[snum]->x)
#define SPR_GET_YPOS(sys,snum)   (sys->sprites[snum]->y)

/* macros to set information for a sprite */
#define SPR_SET_WIDTH(spr_ptr,w)  (spr_ptr->width=w)
#define SPR_SET_HEIGHT(spr_ptr,h) (spr_ptr->height=h)
#define SPR_SET_XPOS(spr_ptr,x)   (spr_ptr->x=x)
#define SPR_SET_YPOS(spr_ptr,y)   (spr_ptr->y=y)

/* sprite data structures */
typedef struct
  {
     USHORT x;			/* current location */
     USHORT y;

     UBYTE speed;		/* movement speed (0 = not moving ) */
     UBYTE speed_counter;
     BYTE xinc;			/* x and y increments when moving  */
     BYTE yinc;

     UBYTE animspeed;		/* animation speed (0 = not animating ) */
     UBYTE animspeed_counter;
     UBYTE noframes;		/* number of animation frames */
     USHORT frame_count;
     USHORT frame;		/* current frame */
     USHORT *animframes;	/* array of frames in animation */

     UBYTE *buffer;		/* holds the info under the sprite */
  }
sprite_record;


typedef struct
  {
     UBYTE width;		/* width of sprite */
     UBYTE height;		/* height of sprite */
     UBYTE *data;		/* x*y array of the data */
     UBYTE *pattern;		/* RLE storage pattern */
     UBYTE no_rects;		/* number of bounding rects */
     UBYTE *rect_coords;	/* coords of rects */
  }
sprite_data_rec;


typedef struct
  {
     USHORT no_sprites;		/* max number of sprites in system     */
     UBYTE *active_sprites;	/* array of flags for active sprites   */
     sprite_record **sprites;	/* array of the sprites themselves     */
     USHORT no_frames;		/* num of sprite data frames in system */
     USHORT number_loaded;      /* number of sprites loaded            */
     sprite_data_rec **sprite_data;	/* array of frame data         */
  }
sprite_system;


  /* function prototypes  */
sprite_system *sprite_init (USHORT max_sprites, USHORT max_frames);
sprite_system *sprite_free (sprite_system * ssys);
UBYTE sprite_load (char *filename, sprite_system * ssys);
void sprite_turn_on (sprite_system * spr_sys, USHORT snum);
void sprite_turn_off (sprite_system * spr_sys, USHORT snum);
void sprite_set_xy (sprite_system * spr_sys, USHORT snum, USHORT newx, USHORT newy);
void sprite_set_an_frame (sprite_system * ssys, USHORT snum, USHORT frame);
USHORT sprite_find_first_free (sprite_system * spr_sys);
void sprite_set_move_info (sprite_system * spr_sys, USHORT snum,
			   UBYTE speed, BYTE xinc, BYTE yinc);
void sprite_set_anim_info (sprite_system * spr_sys, USHORT snum,
			   UBYTE anspeed, UBYTE noframes, USHORT *animpat);
void sprite_update_anim_and_move (sprite_system * spr_sys, USHORT snum);
void sprite_update_all_anim_and_move (sprite_system * spr_sys);
void sprite_do_all_anim_and_move_n_times (sprite_system * spr_sys, int n);
int sprite_do_intersect (sprite_system * spr_sys, USHORT s1, USHORT s2);


/*+-----------------------------------------------------------------------+ */
/*|buffers - offscreen buffer video functions                             | */
/*+-----------------------------------------------------------------------+ */

/* macros to get information about a buffer */
#define B_X_SIZE(buff_ptr) (buff_ptr->width)
#define B_Y_SIZE(buff_ptr) (buff_ptr->height)
#define B_SIZE(buff_ptr)   ((buff_ptr->width)*(buff_ptr->height))
#define B_BUFF_PTR(buff_ptr) (buff_ptr->buffer)


/* buffer data structure */
typedef struct
  {
     USHORT width;		/* width of buffer */
     USHORT height;		/* height of buffer */
     UBYTE *buffer;		/* the buffer */
  }
buffer_rec;


/* function prototypes */
buffer_rec *buff_init (USHORT width, USHORT height);
buffer_rec *buff_free (buffer_rec * buff);
void buff_clear (buffer_rec * buff);
void buff_fill (buffer_rec * buff, int colour);

void buff_blit_buff_to (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
    buffer_rec * sbuff, USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2);

void buff_blit_buff_toNC (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
    buffer_rec * sbuff, USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2);


void buff_draw_point (buffer_rec * buff, USHORT x, USHORT y, UBYTE c);
void buff_draw_pointNC (buffer_rec * buff, USHORT x, USHORT y, UBYTE c);
UBYTE buff_get_point (buffer_rec * buff, USHORT x, USHORT y);
UBYTE buff_get_pointNC (buffer_rec * buff, USHORT x, USHORT y);

void buff_draw_box (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c);
void buff_draw_boxNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c);
void buff_draw_rect (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c);
void buff_draw_rectNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c);

void buff_draw_charNC (buffer_rec * buff, UBYTE letter, USHORT x, USHORT y, UBYTE colour);
void buff_draw_char (buffer_rec * buff, UBYTE letter, USHORT x, USHORT y, UBYTE colour);
void buff_draw_stringNC (buffer_rec * buff, char *string, USHORT x, USHORT y, UBYTE colour);
void buff_draw_string (buffer_rec * buff, char *string, USHORT x, USHORT y, UBYTE colour);

void buff_draw_line (buffer_rec * buff, USHORT x, USHORT y, USHORT x2, USHORT y2, UBYTE c);
void buff_draw_lineNC (buffer_rec * buff, USHORT x, USHORT y, USHORT x2, USHORT y2, UBYTE c);
void buff_draw_h_line (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, UBYTE c);
void buff_draw_h_lineNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, UBYTE c);
void buff_draw_v_line (buffer_rec * buff, USHORT x1, USHORT y1, USHORT y2, UBYTE c);
void buff_draw_v_lineNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT y2, UBYTE c);

void buff_draw_ellipse (buffer_rec * buff, USHORT x0, USHORT y0, USHORT a, USHORT b, UBYTE c);
void buff_draw_ellipseNC (buffer_rec * buff, USHORT x0, USHORT y0, USHORT a, USHORT b, UBYTE c);
void buff_filled_ellipse (buffer_rec * buff, USHORT x0, USHORT y0, USHORT a, USHORT b, UBYTE c);
void buff_filled_ellipseNC (buffer_rec * buff, USHORT x0, USHORT y0, USHORT a, USHORT b, UBYTE c);

#define buff_draw_circle(buff,x0,y0,diam,c) buff_draw_ellipse(buff,x0,y0,diam,diam,c);
#define buff_draw_circleNC(buff,x0,y0,diam,c) buff_draw_ellipseNC(buff,x0,y0,diam,diam,c);
#define buff_filled_circle(buff,x0,y0,diam,c) buff_filled_ellipse(buff,x0,y0,diam,diam,c);
#define buff_filled_circleNC(buff,x0,y0,diam,c) buff_filled_ellipseNC(buff,x0,y0,diam,diam,c);

void buff_convex_polyNC(buffer_rec *buff, int n, int *x, int *y,UBYTE col );

void buff_hollow_poly(buffer_rec *buff, int n, int *x, int *y,UBYTE col );
void buff_hollow_polyNC(buffer_rec *buff, int n, int *x, int *y,UBYTE col );

void buff_draw_sprite (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff);
void buff_draw_spriteNC (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff);
void buff_draw_all_sprites (sprite_system * spr_sys, buffer_rec * obuff);

void buff_save_sprite (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff);
void buff_save_spriteNC (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff);
void buff_save_all_sprites (sprite_system * spr_sys, buffer_rec * obuff);

void buff_rest_sprite (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff);
void buff_rest_spriteNC (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff);
void buff_rest_all_sprites (sprite_system * spr_sys, buffer_rec * obuff);

void buff_stencil_spriteNC (USHORT x, USHORT y, sprite_system * spr_sys,
			    USHORT frame, buffer_rec * obuff);

void buff_stamp_spriteNC (USHORT x, USHORT y, sprite_system * spr_sys,
			  USHORT frame, buffer_rec * obuff);

/*+-----------------------------------------------------------------------+ */
/*|images - routines to load 256 col images from files into buffers       | */
/*+-----------------------------------------------------------------------+ */

#define IMG_WIDTH(img_ptr)  (img_ptr->width)
#define IMG_HEIGHT(img_ptr) (img_ptr->height)
#define IMG_PALETTE(img_ptr) (img_ptr->palette)

typedef struct
  {
     USHORT width;
     USHORT height;
     UBYTE *data;
     UBYTE *palette;
  }
image;


/* function protos */

image *image_free (image * img);

image *image_load_pcx (char *filename);

image *image_load_jlb (char *filename);
int image_save_jlb(char *filename,buffer_rec *buff,UBYTE *pal); 


void buff_blit_img_to (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
	   image * img, USHORT imx1, USHORT imy1, USHORT imx2, USHORT imy2);
void buff_blit_img_toNC (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
	   image * img, USHORT imx1, USHORT imy1, USHORT imx2, USHORT imy2);


#include <jscreen.h>
#include <jinput.h>

/*+-----------------------------------------------------------------------+ */
/*|Font stuff - simple text I/O for debugging etc.                        | */
/*+-----------------------------------------------------------------------+ */

#if SCREEN_WIDTH == 320
#define CHAR_WIDTH(chr)  4
#define CHAR_HEIGHT(chr) 8
#define HAS_FONT(chr)   (((UBYTE)chr>=32) && ((UBYTE)chr<=126))

#else
/* 640x480 and above modes */
#define CHAR_WIDTH(chr)  8
#define CHAR_HEIGHT(chr) 19
#define HAS_FONT(chr)   (((UBYTE)chr>=32) && ((UBYTE)chr<=126))
#endif

extern UBYTE __font_data[];


/*+-----------------------------------------------------------------------+ */
/*|Miscellanious stuff.                                                   | */
/*+-----------------------------------------------------------------------+ */

/* return library version number */
float jlib_return_version_number(void);
char *jlib_return_version_string(void);


/* pop up a screen detailing the jlib target,  version etc */
void popup_about(UBYTE back_col,UBYTE front_col);

/* pop up a message with an OK button */
void popup_info(char *message,UBYTE back_col,UBYTE front_col);


#ifdef __cplusplus
}
#endif 


#define __JLIB_H__


/* end of file */
#endif
