/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for detailed terms. 
*/

#include <jconfig.h>

/* jtypes.h - type definitions */

/* This file must define the types UBYTE,  BYTE,  USHORT and SHORT.
**
** UBYTE should be an 8 bit unsigned number.
** BYTE should be an 8 bit signed number.    
** USHORT should be a 16 bit unsigned number.
** SHORT should be a 16 bit signed number.
**
** No assumptions should be made about the sizes of ints,longs or doubles.
*/

#ifndef __JTYPES_H__
#define __JTYPES_H__

#ifdef __cplusplus
extern "C" {
#endif 

/****************************************************************************/  
#ifdef DJGPP_DPMI_COMPLIANT
/****************************************************************************/  

#define UBYTE   unsigned char
#define BYTE    signed char
#define USHORT  unsigned short int
#define SHORT   short int

#endif /* djgpp */


/****************************************************************************/  
#ifdef LINUX_SVGALIB
/****************************************************************************/  

#define BYTE    signed char
#define UBYTE   unsigned char
#define USHORT  unsigned short int
#define SHORT   short int

#endif  /* linux svgalib */

/****************************************************************************/  
#ifdef LINUX_GRX2
/****************************************************************************/  

#define BYTE    signed char
#define UBYTE   unsigned char
#define USHORT  unsigned short int
#define SHORT   short int

#endif  /* linux svgalib */


/****************************************************************************/  
#ifdef X_WINDOWS
/****************************************************************************/  

/* These certainly work for Linux/X - other X targets may have to be added */
#define BYTE    signed char
#define UBYTE   unsigned char
#define USHORT  unsigned short int
#define SHORT   short int

#endif  /* X windows */


/****************************************************************************/  
#ifdef GENERIC
/****************************************************************************/  

/* assume a system with 8 bit chars and 16 bit shorts */
#define BYTE    char
#define UBYTE   unsigned char
#define USHORT  unsigned short int
#define SHORT   short int

#endif  /* GENERIC */

#ifdef __cplusplus
}
#endif 

#endif /* file */
