#include <dpmi.h>
#include <go32.h>

/* these externs make a pretty ugly hack,  but I had to keep them defined
** in the asm or they wouldn't get locked properly. -jpg */
extern int __jlib_kb_lock_start, __jlib_kb_lock_end;
extern short __jlib_ds;
extern volatile short _k_temp;
extern volatile char key[128];
extern volatile char _key_buffer[255];

/* this locking code is loosely based on work by Charles Sandman from the
 * DJGPP V2 beta 2 release of DJGPP. (file DPMIEXCP.C)
 * Thankyou Charles for your contribution.  Those parts that aren't mine
 * belong to Charles and fall under the following terms:
 *
 * Copyright (C) 1994, 1995 Charles Sandmann (sandmann@clio.rice.edu)
 * Exception handling and basis for signal support for DJGPP V2.0
 * This software may be freely distributed, no warranty.
 *
 * NOTE: Please don't hassle Charles about the code here,  If you have
 *       Any questions I will field them.
*/

void __jlib_lock_kb_handler(void)
{
  __dpmi_meminfo kb_memblock;

  /* get our ds  */
  asm("mov %ds,___jlib_ds");

  /* lock ANY addresses which may see HW interrupts */

  /* firstly the keyboard code and static data (includes most vars) */
  __dpmi_get_segment_base_address(__jlib_ds, &kb_memblock.address);
  kb_memblock.address += (unsigned) &__jlib_kb_lock_start;
  kb_memblock.size = ((unsigned) &__jlib_kb_lock_end
		  - (unsigned) &__jlib_kb_lock_start);
  __dpmi_lock_linear_region(&kb_memblock);

  /* now the temporary key variable */
  __dpmi_get_segment_base_address(__jlib_ds, &kb_memblock.address);
  kb_memblock.address += (unsigned) &_k_temp;
  kb_memblock.size = ((unsigned) 4);
  __dpmi_lock_linear_region(&kb_memblock);

  /* now the key table */
  __dpmi_get_segment_base_address(__jlib_ds, &kb_memblock.address);
  kb_memblock.address += (unsigned) &key;
  kb_memblock.size = ((unsigned) 128);
  __dpmi_lock_linear_region(&kb_memblock);

  /* now the key buffer */
  __dpmi_get_segment_base_address(__jlib_ds, &kb_memblock.address);
  kb_memblock.address += (unsigned) &_key_buffer;
  kb_memblock.size = ((unsigned) 255);
  __dpmi_lock_linear_region(&kb_memblock);


}

