/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */

#include <dos.h>
#include <stdlib.h>
#include <grx.h>
#include <jlib.h>

static int __jlib_previous_mode;  /* holds previous mode */

/* set 640 x 480 x 256 mode and initialise fake context */
int screen_set_video_mode(void)
{
 __jlib_previous_mode = GrCurrentMode(); /* save current mode */

 GrSetMode(GR_width_height_color_graphics,640,480,256);

 __jlib_fake_context = (GrContext *)malloc(sizeof(GrContext));

 if(__jlib_fake_context == NULL){
    JLIB_PRINT_DEBUG_INFO("couldn't initialise context\n");
    exit(0);
 }

 __jlib_fake_partial_context = (GrContext *)malloc(sizeof(GrContext));

 if(__jlib_fake_partial_context == NULL){
    JLIB_PRINT_DEBUG_INFO("couldn't initialise context\n");
    exit(0);
 }

 memset(__jlib_fake_context,0,sizeof(GrContext));
 memset(__jlib_fake_partial_context,0,sizeof(GrContext));

 /* as __jlib_fake_context will only be used for fs blits, do this once only */
 __jlib_fake_context->gc_lineoffset = GrLineOffset(SCREEN_WIDTH);
 __jlib_fake_context->gc_xmax=__jlib_fake_context->gc_xcliphi=SCREEN_MAX_X;
 __jlib_fake_context->gc_ymax=__jlib_fake_context->gc_ycliphi=SCREEN_MAX_Y;
 __jlib_fake_context->gc_planeoffset=GrPlaneSize(SCREEN_WIDTH,SCREEN_HEIGHT);

 return 1; /* mode set ok */
 
}


/* restore text mode */
void screen_restore_video_mode(void)
{
 GrSetMode(__jlib_previous_mode);

}

/*+------------------------------------------------------------------------+*/
/*|Return the current page number ( always 1 in this case)                 |*/
/*+------------------------------------------------------------------------+*/

int screen_get_page(void)
{
 return 1;
}

/*+------------------------------------------------------------------------+*/
/*|Show the current drawing page. ( Has no effect in this mode.)           |*/
/*+------------------------------------------------------------------------+*/

void screen_show_page(int page)
{
 /* do nothing */
}


void screen_wait_vsync(void)
{
 /* not supported yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color                                      | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_fill (UBYTE color) 
{
 GrClearScreen((int)color);

}


/*+------------------------------------------------------------------------+ */
/*|Clear the screen.                                                       | */
/*+------------------------------------------------------------------------+ */ 

void screen_clear (void) 
{
 GrClearScreen(0);

}


