/*
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

#include <dos.h>
#include <mousex.h>
#include <grx.h>
#include <jlib.h>

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */


/*+--------------------------------------------------------------------------+*/
/*|check for the presence of a mouse.                                        |*/
/*+--------------------------------------------------------------------------+*/
/*|this routine should always be called FIRST to initialize the mouse        |*/
/*+--------------------------------------------------------------------------+*/
int mouse_present(void)
{

 if(MouseDetect()){
    MouseEventMode(0);  /* use polled mode */
    MouseInit();

    return MOUSE_PRESENT;
 }
 else{
    return MOUSE_ABSENT;
 }

}


/*+--------------------------------------------------------------------------+*/
/*|shut down the mouse                                                       |*/
/*+--------------------------------------------------------------------------+*/
void mouse_closedown(void)
{
 MouseUnInit();

}

/*+--------------------------------------------------------------------------+*/
/*|show the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_show_pointer(void)
{
 MouseDisplayCursor();

}


/*+--------------------------------------------------------------------------+*/
/*|hide the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_hide_pointer(void)
{
 MouseEraseCursor();
}


/*+--------------------------------------------------------------------------+*/
/*|read pointer coordinates                                                  |*/
/*+--------------------------------------------------------------------------+*/
void mouse_get_status(int *x_pos, int *y_pos, int *b_status)
{
 MouseEvent event;

 MouseGetEvent((M_MOTION | M_BUTTON_CHANGE),&event);

 *x_pos = event.x;
 *y_pos = event.y;
 *b_status = event.buttons;

}

/*+--------------------------------------------------------------------------+*/
/*|change pointer coordinates                                                |*/
/*+--------------------------------------------------------------------------+*/
void mouse_set_status( int x, int y)
{
 /* does nothing here at present */

}


