/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for more details.
 */
		  /* THE FOLLOWING CODE IS LINUX/SVGALIB SPECIFIC */

#include <jlib.h>
#include <vga.h>
#include <vgagl.h>

/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
/*|This routine is just a normal blit that assumes the buffer is the same  | */
/*|size as the screen.                                                     | */
/*+------------------------------------------------------------------------+ */

JINLINE void screen_blit_fs_buffer (buffer_rec * buff)
{

   LONG_COPY (B_BUFF_PTR (buff), vga_getgraphmem (), 64000);

}

#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */

void screen_blit_buff_toNC (USHORT x, USHORT y, buffer_rec * sbuff,
			 USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2)
{
   int v_len = sby2 - sby1, h_len = sbx2 - sbx1;
   UBYTE *src = B_BUFF_PTR (sbuff) + (B_X_SIZE (sbuff) * sby1) + sbx1;
   UBYTE *dest = vga_getgraphmem () + (y * SCREEN_WIDTH) + x;
   int width = B_X_SIZE (sbuff);

   /* i MUST rewrite these to use ALIGN_STATE_1 etc!!!!!!! */
   for (; v_len != 0; v_len--)
     {
	FAST_LONG_COPY (src, dest, h_len);
	src += width;
	dest += SCREEN_WIDTH;
     }

}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */

void screen_blit_buff_to (USHORT x, USHORT y, buffer_rec * sbuff,
			  USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2)
{

   int v_len = sby2 - sby1, h_len = sbx2 - sbx1;
   UBYTE *src = B_BUFF_PTR (sbuff);
   UBYTE *dest = vga_getgraphmem () + (y * SCREEN_WIDTH) + x;
   int width = B_X_SIZE (sbuff);

   if (sbx1 > sbx2)
     {
	_SWAP (sbx1, sbx2);
     }

   if (sby1 > sby2)
     {
	_SWAP (sby1, sby2);
     }

   if ((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y))
     {
	return;
     }

   if ((x + h_len) > SCREEN_MAX_X)
     {
	h_len = SCREEN_MAX_X - x;
     }

   if ((y + v_len) > SCREEN_MAX_Y)
     {
	v_len = SCREEN_MAX_Y - y;
     }

   src += (B_X_SIZE (sbuff) * sby1) + sbx1;

   /* i MUST rewrite these to use ALIGN_STATE_1 etc!!!!!!! */
   for (; v_len != 0; v_len--)
     {
	FAST_LONG_COPY (src, dest, h_len);
	src += width;
	dest += SCREEN_WIDTH;
     }

}
