
/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "jlib.doc" for details.
 */

		  /* THE FOLLOWING CODE IS SVGALIB SPECIFIC */

#include <jlib.h>
#include <vga.h>
#include <vgagl.h>


/*+------------------------------------------------------------------------+ */
/*|set video mode  13h                                                     | */
/*+------------------------------------------------------------------------+ */

int screen_set_video_mode (void)
{ 
  if(!vga_init ()){
     if(!vga_setmode (G320x200x256)){
        gl_setcontextvga (G320x200x256);

        return 1; /* mode set successful */
     }
     else{
        screen_restore_video_mode();
        return 0; /* mode set failed */
     }
  }   
  else{
    screen_restore_video_mode();
    return 0; /* mode set failed */
  }

}


/*+------------------------------------------------------------------------+ */
/*|use the bios to set video mode  03h (text)                              | */
/*+------------------------------------------------------------------------+ */

void screen_restore_video_mode (void)
{

   vga_setmode (TEXT);

}

/*+------------------------------------------------------------------------+ */
/*|Return the current page number ( always 1 in this case)                 | */
/*+------------------------------------------------------------------------+ */

int screen_get_page (void)
{
   return 1;
}

/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page. ( Has no effect in this mode.)           | */
/*+------------------------------------------------------------------------+ */

void screen_show_page (int page)
{
   /* do nothing */
}

void screen_wait_vsync (void)
{
   /* not implememted yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color                                      | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_fill (UBYTE color) 
{
  
 memset(vga_getgraphmem(),color,64000); 
   
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_clear (void) 
{
  
 memset(vga_getgraphmem(),0,64000); 
   
}
