/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
/*
 * X Version Copyright (C) 1995 Mike Manley
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <stdio.h>
#include <jlib.h>
#include <X11/Xlib.h>

/* Set an entry in the X Colormap */
JINLINE void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
	XColor jxcol;
	XEvent event;

	/* Set up an XColor */
	jxcol.pixel = col;
	jxcol.red = (red << 8) | red;
	jxcol.green = (green << 8) | green;
	jxcol.blue = (blue << 8) | blue;
	jxcol.flags = DoRed | DoGreen | DoBlue;
	/* and store it to the colormap */
	XStoreColor(jxdisplay, jxcolormap, &jxcol);
	/* Do we need to flush the display ? I think we do! */
	/* Ideally for the multiple pallete sets below we want another function */
	/* that doesn't flush the display and then a single flush at the end */
	XFlush(jxdisplay);
}

/* Set a block of entries in the X Colormap */
void screen_block_set_pal(UBYTE *pal)
{
 int i;
   
   for(i=0;i<256;i++) {
       screen_put_pal(i,*pal,*(pal+1),*(pal+2));
       pal+=3;
   }
      
}



/* Set all entries in X Colormap to zero */
void screen_blank_pal(void)
{
 int i;
   
 for(i=255;i>=0;i--){
    screen_put_pal(i,0,0,0);
 }
   
}


/*+------------------------------------------------------------------------+*/
/*|load a palette from a file                                              |*/
/*+------------------------------------------------------------------------+*/

#define SIZEOFPAL 768

UBYTE *screen_load_pal(char *fname)
{
 UBYTE *tmp;
 FILE *fp;

 /* allocate memory for the palette */
 if((tmp = (UBYTE *)malloc(SIZEOFPAL*sizeof(UBYTE)))==NULL){
    JLIB_SPRINTF(JLIB_MESSAGE_STRING,"Malloc Failed at screen_load_pal line %d\n",__LINE__);
    JLIB_PRINT_MESSAGE_STRING;

    return (UBYTE *)NULL;
 }

 /* open file */
 if((fp = fopen(fname,"rb"))==NULL){
    JLIB_SPRINTF(JLIB_MESSAGE_STRING,"Couldn't open palette file %s\n",fname);
    JLIB_PRINT_MESSAGE_STRING;

    return (UBYTE *)NULL;
 }

 /* read in the palette */
 fread(tmp,(sizeof(UBYTE)*SIZEOFPAL),1,fp);

 /* give if back */
 return tmp;
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette in                                                       |*/
/*+------------------------------------------------------------------------+*/

#define PALSIZE 255

void delay(unsigned msec);  /* where is this prototyped? */

void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE*3];

  memset(temp_pal,(int)0,PALSIZE*3);

  for(i=1;i<64;i++){
      for(j=0;j<(PALSIZE*3);j++){
	  temp_pal[j] = pal[j] * i / 64;
      }

      screen_block_set_pal(temp_pal);
     /* delay(delaytime); */
  }
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette out                                                      |*/
/*+------------------------------------------------------------------------+*/

void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE*3];

  /* copy the palette into our local copy */
  FAST_SHORT_COPY(pal,temp_pal,(PALSIZE*3));

  for(i=64;i>0;i--){
      for(j=0;j<(PALSIZE*3);j++){
	  temp_pal[j] = pal[j] * i / 64;
      }

      screen_block_set_pal(temp_pal);
      /* delay(delaytime); */
  }

}

