/* pcx2jlb.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

/* this is a simple converter. A more complex converter that handles more
** flavours of .pcx will hopefully not be long. - jpg. 
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <jlib.h>

int main(int argc,char *argv[])
{
 image *pcx_pic; 
 buffer_rec *offscreen;
 unsigned char *pal;
 char *outname;
 
 
 if(argc != 2){
    puts("pcx2jlb: Convert a pcx file into a .jlb file.");
    puts("Useage: pcx2jlb <infile>");
    exit(-1);
 }
 
 /* load pcx */
 pcx_pic = image_load_pcx(*++argv);

 /* check that load was OK */
 if(pcx_pic == NULL){
    printf("ERROR:could not load .pcx file.\n");
    exit(-1);
 }

 /* set pal to point to the image's palette */
 pal = IMG_PALETTE(pcx_pic);

 /* initialise a buffer the size of the image */
 offscreen = buff_init(IMG_WIDTH(pcx_pic),IMG_HEIGHT(pcx_pic));

 /* check that initialisation was OK */
 if(offscreen == NULL){
    printf("ERROR: Could not initialise buffer (out of memory).\n");
    exit(-1);
 }

 /* copy the image to the buffer */
 buff_blit_img_to(offscreen,0,0,pcx_pic,0,0,IMG_WIDTH(pcx_pic),IMG_HEIGHT(pcx_pic));

 /* form destination file name */
 outname = strrchr (*argv, '.');
 
 if(strlen(outname) < 4){
    puts("ERROR: the Input file has an incorrect extension.");
    exit(-1);
 }
 
 strcpy(outname,".jlb");        /* add extension */
 outname = *argv;
        
 /* save the buffer as a .jlb file */
 if(image_save_jlb(outname,offscreen,IMG_PALETTE(pcx_pic)) == 0){
  puts("ERROR: Output file may be corrupt.");
  exit(-1);
 }
 
 printf("Output correctly written to file %s.\n",*argv);

 return 0;
}