program CharsGen;

{***************************************************************************}
{																			}
{		Author:				Kevin A. Lee									}
{																			}
{		Last Amended:		11th February, 1993								}
{																			}
{		Description:		Program to generate a set of font data suitable	}
{							for the pasKAL graphics library. You pass the	}
{							name of the font to the program e.g. FontName,	}
{							the program reads the text data from the file	}
{							FontName.TXT and outputs it to FontName.PAS		}
{							Examples fonts LineFont and TinyFont are		}
{							included.										}
{																			}
{***************************************************************************}

uses
	Dos;

const
	NumArrays = 96;

var
	fIn, fOut: text;
    inName, outName: string;


procedure ConvertData;
var
	value, j, i, k: byte;
    Ch: char;
begin

	WriteLn(fOut, 'const');
    WriteLn(fOut, ParamStr(1), ': Font = (');
	for k := 1 to NumArrays do
    begin
		Write(fOut, '(');
		for i := 1 to 8 do
    	begin
			value := 0;
        	for j := 1 to 8 do
        	begin
        		value := 2 * value;
        		Read(fIn, Ch);
            	if (Ch = '#') then INC(value);
        	end;
        	Write(fOut, value);
        	if (i <> 8) then Write(fOut, ',');
        	ReadLn(fIn);
    	end;
        if (k = NumArrays) then WriteLn(fOut, ')')
        else WriteLn(fOut, '),');
        Read(fIn, Ch);
        Read(fIn, Ch);
    end;
    WriteLn(fOut, ');');
end; {ConvertData}


begin
	if ParamCount < 1 then
    begin
    	WriteLn('Usage: CHARSGEN <fontname>.');
        WriteLn('e.g. CHARSGEN LineFont');
        Halt(1);
    end;

    WriteLn('Converting ', ParamStr(1), '...');

    inName  := ParamStr(1);
    outName := ParamStr(1);

    inName := concat(inName, '.TXT');
    assign(fIn, inName);
    {$I-} reset(fIn); {$I+}
    if (IOResult <> 0) then
	begin
    	WriteLn('Error: Cannot open file ', inName, 'for reading.');
        Halt(2);
    end;

	outName := concat(outName, '.PAS');
    assign(fOut, outName);
    {$I-} rewrite(fOut); {$I+}
    if (IOResult <> 0) then
    begin
    	WriteLn('Error: Cannot open file ', outName, 'for writing.');
        Halt(3);
    end;

    ConvertData;

    close(fIn);
    close(fOut);

    WriteLn('Conversion complete...');

end.