program Demo2;

uses
	MCGA256, Crt, Memory;

var
  	RandomStep: real;
  	RandomColour: byte;
    StandardPal: PaletteArray;
    Ch: char;




procedure ErrorReadingFile;
begin
	CloseGraphics;
    WriteLn('Program terminated: Error reading file.');
    Halt(2);
end; {ErrorReadingFile}



procedure DrawPattern(AngularStep: real; ColourOffset: byte);
var
  	ScaleFactor, Degrees: real;
  	XPos, YPos, OldX, OldY: integer;
    PenColour: byte;
begin
	FillRectangle(0, 0, 319, 199, 0);
  	ScaleFactor := 1;
  	Degrees := 0;
  	XPos := 157;
  	YPos := 95;
    PenColour := ColourOffset;

	while (Degrees < 300) and (not keypressed) do
    begin
    	OldX := XPos;
    	OldY := YPos;
    	XPos := Round(157 + Cos(Degrees) * 124 * ScaleFactor);
    	YPos := Round(95  + Sin(Degrees) * 94  * ScaleFactor);
    	Line(OldX, OldY, XPos, YPos, PenColour);
        if (PenColour = ColourOffset+16) then
        	PenColour := ColourOffset
        else
        	INC(PenColour);
    	ScaleFactor := ScaleFactor * 0.99;
    	Degrees := Degrees + AngularStep
    end;

    if (Degrees >= 300) then Delay(2000);
end; {DrawPattern}



begin
	if (not OpenGraphics) then
    begin
    	WriteLn('Error opening graphics library.');
        Halt(1);
    end;

  	Randomize;
    if (not LoadPalette('STANDARD.PAL', StandardPal)) then ErrorReadingFile;
    SetPalette(StandardPal);
    SetActivePage(UserScreen);

  	DrawPattern(3.1, 95);
  	DrawPattern(2.11, 31);
  	DrawPattern(1.58, 127);   		{ preset patterns }
  	DrawPattern(1.24, 63);
  	DrawPattern(1.832, 159);

  	while (not keypressed) do
    begin
    	RandomStep := Random(3) + 0.5;
    	RandomColour := (Random(10) + 2)*16+15;
    	DrawPattern(RandomStep, RandomColour);
  	end;

	Ch := ReadKey;
    CloseGraphics;
end.
