program MouseTest;

{***************************************************************************}
{																			}
{		Author:				Kevin A. Lee									}
{																			}
{		Last Amended:		22nd January, 1993								}
{																			}
{		Description:		Test program for pasKAL graphics library and	}
{							mouse routines. The program initialses the		}
{							mouse driver, changes the cursor and limits		}
{							it to an area of the screen. When the left		}
{							button is pressed the current coordinates are	}
{							displayed. The program terminates when the		}
{							right button is pressed.						}
{																			}
{***************************************************************************}

uses
  	MCGA256, Mouse, Crt, Memory;

const
    HandShape: MouseCursorShape =
    	(mask: { screen ANDed with this part }
        	($E1FF, $E1FF, $E1FF, $E1FF, $E1FF, $0000, $0000, $0000,
             $0000, $0000, $0000, $0000, $0000, $0000, $0000, $0000,
			   { screen XORed with this part }
        	 $1E00, $1200, $1200, $1200, $1200, $13FF, $1249, $1249,
             $F249, $9001, $9001, $9001, $8001, $8001, $8001, $FFFF);
             xHot: 5; yHot: 0);

var
	Button: word;
    ev: MouseEvent;
    finished: boolean;
    buf: string;


begin
	if (not OpenGraphics) then
    begin
    	WriteLn('Error opening graphics library.');
        Halt(1);
    end;

    if (not InitialiseMouse(Button)) then
    begin
    	CloseGraphics;
    	WriteLn('Error: Mouse not present');
        Halt(2);
    end;

    SetActivePage(UserScreen);

    MouseShape(HandShape);					{ Change mouse shape }
    MouseLimits(99, 49, 219, 149);			{ Limit mouse area }
    Rectangle(99, 49, 219, 149, 1);			{ Hilite area }
    SetMousePosition(159, 99);				{ Set initial position }
    ShowMouse;								{ Show the mouse }
    finished := false;

    while (not finished) do
    begin
    	if (GetMouseEvent(ev)) then
        begin
        	if (ev.button = LeftButton) then
            begin
            	{ display position }
            	FillRectangle(0, 0, 200, 30, 0);
                Str(ev.xpos, buf);
                DisplayString(buf, 0, 10, 15);
                DisplayChar(':', 30, 10, 7);
                Str(ev.ypos, buf);
                DisplayString(buf, 40, 10, 15);
            end;

            if (ev.button = RightButton) then finished := true;
        end;
    end;

    CloseGraphics;
end.