/**********************************************

	Example #02 for the Reglage VGA-Library

		TEXT MODE
		Screen Experimenting

	V1.0 - Reglage (C) 1994

**********************************************/

#include <math.h>	//	For the sinetable Calculus
						//	This really should be precalculated!

#include "Keyb.h"
#include "VGA.h"
#include "VGA_T.h"

#include "CooLogo.c"				//	The c00l Logotype! Don't forget! :-)


/**********************************************

	main() ... Just a little test!

**********************************************/

int main(void)
{
	struct Palette OldPalette[16];
	struct Palette NewPalette[16]=
	{
		{ 0x00,0x00,0x00 },
		{ 0x08,0x00,0x1c },
		{ 0x00,0x1c,0x08 },
		{ 0x08,0x18,0x1c },
		{ 0x20,0x00,0x00 },
		{ 0x1c,0x04,0x1c },
		{ 0x20,0x14,0x18 },
		{ 0x1a,0x1a,0x1a },
		{ 0x0e,0x0e,0x0e },
		{ 0x08,0x18,0x3f },
		{ 0x00,0x3a,0x00 },
		{ 0x00,0x3a,0x3a },
		{ 0x3a,0x00,0x00 },
		{ 0x3f,0x00,0x30 },
		{ 0x3f,0x38,0x10 },
		{ 0x3f,0x3f,0x3f }
	};

	UBYTE sinetable[256];	//	Length 256, Amplitude 256 (0-255)
	UWORD i,x,y,sp=1,xcnt,ycnt;
	int x1,x2,y1,y2;

	V_SetMode(3);						// Set TextMode 80X25

	for(i=0;i<256;i++)				//	Create sinetable
		sinetable[i]=(128.0*sin(i*4.41786466898438/180)+127)+0.5;

	for(i=0;i<16;i++)
	{
		T_GetPal(i,&OldPalette[i]);//	Store Old Palette
		T_SetPal(i,&NewPalette[i]);//	Setup New Palette
	}

	T_SetCursor(0);					//	Set Cursor Invisible
	T_ClearScreen(0);					//	Clear ALL Screen Memory
	T_ScreenWidth(80*3);				//	Set Physical Screen Width to 3*80
	T_ScreenOffset(80);				//	Center Visual Screen on the 2nd
											//	Physical Screen

	for(x=0;x<COOLOGO_WIDTH;x++)	//	Move the COOLOGO to the Screen
		for(y=0;y<(COOLOGO_DEPTH);y++)
			T_screen[(y+25)*T_width+x+96]=COOLOGO[(x+y*COOLOGO_WIDTH)*2]+(COOLOGO[(x+y*COOLOGO_WIDTH)*2+1]<<8);

	K_EatKbHit();						//	Eat Keypress

	x1=x2=y1=y2=0;
	xcnt=0;								//	SinPointer
	ycnt=256/4;							//	CosPointer

	while(K_KbHit())					//	Continue while no keypresses
	{
		xcnt+=sp;						//	Increase SinPointer
		ycnt+=sp;						//	Increase CosPointer
		xcnt&=255;						//	If>255then-256
		ycnt&=255;						//	If>255then-256
		x=sinetable[xcnt]*5.625+0.5;	//	Constant Multiplied is 160/256*9
		y=sinetable[ycnt]*3.125+0.5;	//	Constant Multiplied is 50/256*16

		x/=4;									//	Divide Horizontal Amplitude by 4
		x1=x/9+62;								//	...thus Adding 62 to Horizontal Pos
		x2=x%9;								//	Fine Value Calculated
		x2=--x2<0?8:x2;					//	Fine Value Corrected due to VGA Stuff

		y/=2;
		y1=((y/16)+6)*T_width;
		y2=y&15;

		asm cli;								//	Wait for Beginning of Vertical Blanking
		asm	mov	dx,0x3da;
W1:
		asm	in		al,dx;
		asm	test	al,8;
		asm	jnz	W1;

		T_ScreenOffset(x1+y1);			//	Set Appropriate Scrolling Values
		T_HorizontalFine(x2);			//	Set HorizontalFine WHILE VB!

		asm	mov	dx,0x3da;			//	Wait for Vertical Blanking to End
W2:
		asm	in		al,dx;
		asm	test	al,8;
		asm	jz		W2;
		asm sti;

		V_VerticalFine(y2);				//	Set VerticalFine AFTER VB!
	}

	K_EatKbHit();						//	Eat Keypress

	for(i=0;i<16;i++)
	{
		T_SetPal(i,&OldPalette[i]);//	Restore Original Palette
	}

	V_SetMode(3);						// Set TextMode 80X25

	return 0;
}
