/**********************************************

	Generic VGA Routines V0.1
	Copyright Reglage (C) 1994

	VGArtns.c

**********************************************/

#include "vga.h"


/**********************************************

	BIOS Set 'Graphics' Mode

**********************************************/

void V_SetMode(UWORD mode)
{
	asm	mov	ax,mode;
	asm	int	0x10;
}


/**********************************************

	BIOS Get 'Graphics' Mode

**********************************************/

UWORD V_GetMode(void)
{
	asm	mov	ah,0x0f;
	asm	int	0x10;

	return _AL;
}


/**********************************************

	Wait for Vertical Blanking

**********************************************/

void V_WaitVB(void)
{
	asm	mov	dx,0x3da;
W1:
	asm	in		al,dx;
	asm	test	al,8;
	asm	jnz	W1;
W2:
	asm	in		al,dx;
	asm	test	al,8;
	asm	jz		W2;
}


/**********************************************

	Set Line for Split Screen

	(The Split Screen is ALWAYS Offset 0
	 in Memory!)

**********************************************/

void V_SplitScreen(UWORD LineCompare)
{
	asm{
		mov	ax,LineCompare
		shl	ax,1
		mov	bl,ah
		mov	ah,al
		mov	bh,bl
		shr	bh,1		// bit 9
		shl	bh,6
		and	bl,1		// bit 8
		shl	bl,4
		mov	dx,0x3d4
		mov	al,0x18
		out	dx,ax		// The lower 8 bits ok!

		mov	al,7
		out	dx,al

		inc	dx
		in 	al,dx
		and	al,0xff-16
		or 	al,bl
		mov	ah,al
		mov	al,7
		dec	dx
		out	dx,ax		// Bit 8 Ok!

		mov	al,9
		out	dx,al

		inc	dx
		in 	al,dx
		and	al,0xff-64
		or 	al,bh
		mov	ah,al
		dec	dx
		mov	al,9
		out	dx,ax		// Bit 9..
	}
}


/**********************************************

	Set Vertical Fine Scroll Register

	>Text mode: no more than 1 character,
	>VGA: 9 pixels!)
	>
	>Val: 0 1 2 3 4 5 6 7 8
	>Pos: 1 2 3 4 5 6 7 8 0

**********************************************/

void V_VerticalFine(UBYTE Y)
{
	asm{
		mov	dx,0x3d4;
		mov	ah,Y;
		mov	al,8;
		out	dx,ax;
	}
}


/**********************************************

	Set Horizontal PEL Panning Register

	>Text mode: no more than 1 character!

**********************************************/

void V_HorizontalFine(UBYTE X)
{
	asm{
		mov	dx,0x3c0;
		mov	al,0x33;
		out	dx,al;
		mov	al,X;
		out	dx,al;
	}
}


/**********************************************

	VGA Set Palette Color at Index Col

**********************************************/

void V_SetPal(UBYTE Col, UBYTE R, UBYTE G, UBYTE B)
{
	asm{
		mov	al,Col;
		mov	dx,0x03c8;
		out	dx,al;

		inc	dl;	//	mov	dx,0x03c9;
		mov	al,R;
		out	dx,al;
		mov	al,G;
		out	dx,al;
		mov	al,B;
		out	dx,al;
	}
}


/**********************************************

	Get Palette Color at Index Col

**********************************************/

void V_GetPal(UBYTE Col, UBYTE *R, UBYTE *G, UBYTE *B)
{
	asm{
		mov	dx,0x03c7;
		mov	al,Col;
		out	dx,al;

		mov	dx,0x03c9;
	}
	asm	in		al,dx;
	*R=_AL;
	asm	in		al,dx;
	*G=_AL;
	asm	in		al,dx;
	*B=_AL;
}
