/**********************************************

	VGA BIOS Calls V0.1
	Copyright Reglage (C) 1994

	VGArtns.c

**********************************************/

#include "VGA_BIOS.h"


UBYTE	VB_Page=0;




/**********************************************

	BIOS Set 'Graphics' Mode

**********************************************/

void VB_SetMode(UWORD mode)
{
	asm	mov	ax,mode;
	asm	int	0x10;
}


/**********************************************

	BIOS Get 'Graphics' Mode

**********************************************/

UWORD VB_GetMode(void)
{
	asm	mov	ah,0x0f;
	asm	int	0x10;

	return _AL;
}


/**********************************************

	Set Cursor Type	0: Invisible
							1:	Full
							2:	Normal

	Change to NO BIOS CALL!
	Let the BIOS library do it's stuff.

**********************************************/

void VB_SetCursor(UBYTE type)
{
	UBYTE cstart, cend;

	switch(type)
	{
		case 0:	cstart=0x20;	cend=0;	break;
		case 1:	cstart=0;		cend=7;	break;
		case 2:	cstart=6;		cend=7;	break;
	}

	asm{
		mov	ch,cstart;
		mov	cl,cend;
		mov	ah,1;
		int	0x10;
	}
}


/**********************************************

	Set Cursor Position

	Bug: Does not work with T_width other than 80!
	Correction: Use VGA ports to change address pointer for Cursor! :)

**********************************************/

void VB_SetCursorPos(UBYTE x,UBYTE y)
{
	asm{
		mov	ah,0x02;
		mov	bh,0x00;
		mov	dl,x;
		mov	dh,y;
		int	0x10;
	}
}

/**********************************************

	Get Cursor Position

**********************************************/

void VB_GetCursorPos(UBYTE *x,UBYTE *y)
{
	asm{
		mov	ah,0x03;
		mov	bh,VB_Page;
		int	0x10;
	}
	*x=_DL;
	*y=_DH;
}
