UNIT Mouse256;   { by The Faker in 1992 }
INTERFACE
USES
    Crt,Dos;
TYPE
    MouseMenuFlags=ARRAY[1..20] OF Boolean;
    MaskType=ARRAY[0..1,0..15] OF Word;
    MaskPointer=^MaskRec;
    MaskRec=RECORD
                  Mask:MaskType;
                  X,Y:Word;
            END;
VAR
   RightArrowCursor,DownArrowCursor,InvertedCursor:MaskRec;
CONST
     LeftB:Byte=0;
     RightB:Byte=1;
     StandardCursor:MaskRec=(Mask:(($3FFF,$1FFF,$0FFF,$07FF,$03FF,$01FF,$00FF,$007F,$003F,$001F,$01FF,$10FF,$30FF,$F87F,
     $F87F,$FC3F),($0000,$4000,$6000,$7000,$7800,$7C00,$7E00,$7F00,$7F80,$7FC0,$7C00,$4600,$0600,$0300,$0300,$0180));X:0;Y:0);
     UpArrowCursor:MaskRec=(Mask:(($F9FF,$F0FF,$E07F,$E07F,$C03F,$C03F,$801F,$801F,$000F,$000F,$F0FF,$F0FF,$F0FF,$F0FF,
     $F0FF,$F0FF),($0000,$0600,$0F00,$0F00,$1F80,$1F80,$3FC0,$3FC0,$7FE0,$0600,$0600,$0600,$0600,$0600,$0600,$0600));X:5;Y:0);
     LeftArrowCursor:MaskRec=(Mask:(($FE1F,$F01F,$0000,$0000,$0000,$F01F,$FE1F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
     $FFFF,$FFFF),($0000,$00C0,$07C0,$7FFE,$07C0,$00C0,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));X:0;Y:3);
     CheckMarkCursor:MaskRec=(Mask:(($FFF0,$FFE0,$FFC0,$FF81,$FF03,$0607,$000F,$001F,$C03F,$F07F,$FFFF,$FFFF,$FFFF,$FFFF,
     $FFFF,$FFFF),($0000,$0006,$000C,$0018,$0030,$0060,$70C0,$1D80,$0700,$0000,$0000,$0000,$0000,$0000,$0000,$0000));X:6;Y:7);
     PointingHandCursor:MaskRec=(Mask:(($E1FF,$E1FF,$E1FF,$E1FF,$E1FF,$E000,$E000,$E000,$0000,$0000,$0000,$0000,$0000,$0000,
     $0000,$0000),($1E00,$1200,$1200,$1200,$1200,$13FF,$1249,$1249,$F249,$9001,$9001,$9001,$8001,$8001,$8001,$FFFF));X:5;Y:0);
     DiagonalCrossCursor:MaskRec=(Mask:(($07E0,$0180,$0000,$C003,$F00F,$C003,$0000,$0180,$07E0,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
     $FFFF,$FFFF),($0000,$700E,$1C38,$0660,$03C0,$0660,$1C38,$700E,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));X:7;Y:4);
     RectangleCrossCursor:MaskRec=(Mask:(($FC3F,$FC3F,$FC3F,$0000,$0000,$0000,$FC3F,$FC3F,$FC3F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
     $FFFF,$FFFF),($0000,$0180,$0180,$0180,$7FFE,$0180,$0180,$0180,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));X:7;Y:4);
     HourGlassCursor:MaskRec=(Mask:(($0000,$0000,$0000,$0000,$8001,$C003,$E007,$F00F,$E007,$C003,$8001,$0000,$0000,$0000,$0000,
     $FFFF),($0000,$7FFE,$6006,$300C,$1818,$0C30,$0660,$03C0,$0660,$0C30,$1998,$33CC,$67E6,$7FFE,$0000,$0000));X:7;Y:7);

PROCEDURE ResetMouse;
PROCEDURE ShowMouse;
PROCEDURE HideMouse;
PROCEDURE MousePos(VAR X,Y:Word);
FUNCTION LeftButton:Boolean;
FUNCTION RightButton:Boolean;
PROCEDURE PutMouse(X,Y:Word);
FUNCTION ButtonPressInfo(Button:Byte; VAR PressCount,X,Y:Word):Boolean;
FUNCTION ButtonReleaseInfo(Button:Byte; VAR PressCount,X,Y:Word):Boolean;
PROCEDURE SetHorizontalRange(Min,Max:Word);
PROCEDURE SetVerticalRange(Min,Max:Word);
FUNCTION MouseInBox(X1,Y1,X2,Y2:Word):Boolean;
PROCEDURE SetGraphicsCursor(VAR MaskP:MaskRec);
PROCEDURE SetTextCursor(Sel,Start,Stop:Word);
PROCEDURE MotionCounters(VAR X,Y:Integer);
PROCEDURE LightPenEmulation(F:Boolean);
PROCEDURE ConditionalOff(UX,UY,LX,LY:Word);
PROCEDURE DoubleSpeedThreshold(Mickey:Word);
PROCEDURE SetMouseProcedure(M:Word; P:Pointer);
PROCEDURE CursorMirror(VAR S,D:MaskRec; F:Byte);

IMPLEMENTATION

VAR
   CrtMode:Byte ABSOLUTE $40:$49;
   MouseHandler,ExitSave,Int1BSave,OldCursor:Pointer;
CONST
     M1:Word=0;
     M2:Word=0;
     M3:Word=0;
     M4:Word=0;
     M5:Word=0;
     M6:Word=0;
     MaxX:Integer=719;
     MaxY:Integer=347;
     SegPointer:Word=$FFFF;
     AboFlag:Boolean=FALSE;
     Hercules:Boolean=FALSE;

FUNCTION BitSet(TestByte,BitNumber:Byte):Boolean;
BEGIN
     TestByte:=TestByte AND (1 SHL BitNumber);
     BitSet:=TestByte>0;
END;

PROCEDURE CheckPos(VAR X,Y:Word);
BEGIN
     IF Y>MaxY THEN
        Y:=MaxY;
     IF X>MaxX THEN
        X:=MaxX;
END;

PROCEDURE Mouse;
VAR
   Regs:Registers;
BEGIN
     WITH Regs DO
     BEGIN
          AX:=M1;
          BX:=M2;
          CX:=M3;
          DX:=M4;
          SI:=M5;
          DI:=M6;
          ES:=SegPointer;
          Intr(51,Regs);
          M1:=AX;
          M2:=BX;
          M3:=CX;
          M4:=DX;
     END;
END;

PROCEDURE ShowMouse;
BEGIN
     M1:=1;
     Mouse;
END;

PROCEDURE HideMouse;
BEGIN
     M1:=2;
     Mouse;
END;

PROCEDURE MousePos(VAR X,Y:Word);
BEGIN
     M1:=3;
     Mouse;
     X:=M3;
     Y:=M4;
     IF AboFlag THEN
     BEGIN
          NoSound;
          WriteLn('Break');
          Halt(1);
     END;
END;

FUNCTION LeftButton:Boolean;
BEGIN
     M1:=3;
     Mouse;
     IF BitSet(M2,LeftB) THEN
        LeftButton:=TRUE
     ELSE LeftButton:=FALSE;
END;

FUNCTION RightButton:Boolean;
BEGIN
     M1:=3;
     Mouse;
     IF BitSet(M2,RightB) THEN
        RightButton:=TRUE
     ELSE RightButton:=FALSE;
END;

PROCEDURE PutMouse(X,Y:Word);
BEGIN
     CheckPos(X,Y);
     M1:=4;
     M3:=X;
     M4:=Y;
     Mouse;
END;

FUNCTION ButtonPressInfo(Button:Byte; VAR PressCount,X,Y:Word):Boolean;
BEGIN
     M1:=5;
     M2:=Button;
     Mouse;
     ButtonPressInfo:=BitSet(M1,Button);
     PressCount:=M2;
     X:=M3;
     Y:=M4;
END;

FUNCTION ButtonReleaseInfo(Button:Byte; VAR PressCount,X,Y:Word):Boolean;
BEGIN
     M1:=6;
     M2:=Button;
     Mouse;
     ButtonReleaseInfo:=NOT BitSet(M1,Button);
     PressCount:=M2;
     X:=M3;
     Y:=M4;
END;

PROCEDURE SetHorizontalRange(Min,Max:Word);
VAR
   Dummy:Word;
BEGIN
     CheckPos(Min,Dummy);
     CheckPos(Max,Dummy);
     M1:=7;
     M3:=Min;
     M4:=Max;
     Mouse;
END;

PROCEDURE SetVerticalRange(Min,Max:Word);
VAR
   Dummy:Word;
BEGIN
     CheckPos(Dummy,Min);
     CheckPos(Dummy,Max);
     M1:=8;
     M3:=Min;
     M4:=Max;
     Mouse;
END;

FUNCTION MouseInBox(X1,Y1,X2,Y2:Word):Boolean;
VAR
   X,Y:Word;
BEGIN
     IF X2<X1 THEN
     BEGIN
          X:=X1;
          X1:=X2;
          X2:=X;
     END;
     IF Y2<Y1 THEN
     BEGIN
          Y:=Y1;
          Y1:=Y2;
          Y2:=Y
     END;
     MousePos(X,Y);
     MouseInBox:=(X>=X1) AND (X<=X2-1) AND (Y>=Y1) AND (Y<=Y2-1);
END;

PROCEDURE SetGraphicsCursor(VAR MaskP:MaskRec);
BEGIN
     IF OldCursor<>@MaskP THEN
     BEGIN
          OldCursor:=@MaskP;
          WITH MaskP DO
          BEGIN
               M1:=9;
               M2:=X;
               M3:=Y;
               M4:=Ofs(Mask);
               SegPointer:=Seg(Mask);
          END;
     END;
     Mouse;
END;

PROCEDURE SetTextCursor(Sel,Start,Stop:Word);
BEGIN
     M1:=10;
     M2:=Sel;
     M3:=Start;
     M4:=Stop;
     Mouse;
END;

PROCEDURE MouseRatio(X,Y:Word);
BEGIN
     M1:=15;
     M3:=X;
     M4:=Y;
END;

PROCEDURE MotionCounters(VAR X,Y:Integer);
VAR
   X1,Y1:LongInt;
BEGIN
     M1:=11;
     Mouse;
     IF M3>$FFF THEN
        X1:=M3-65536
     ELSE X1:=M3;
     IF M4>$FFF THEN
        Y1:=M4-65536
     ELSE Y1:=M4;
     X:=X1;
     Y:=Y1;
END;

PROCEDURE LightPenEmulation(F:Boolean);
BEGIN
     IF F THEN
        M1:=13
     ELSE M1:=14;
     Mouse;
END;

PROCEDURE ConditionalOff(UX,UY,LX,LY:Word);
BEGIN
     M1:=16;
     IF UX<LX THEN
     BEGIN
          M3:=UX;
          M5:=LX;
     END
     ELSE
     BEGIN
          M3:=LX;
          M5:=UX;
     END;
     IF UY<LY THEN
     BEGIN
          M4:=UY;
          M6:=LY;
     END
     ELSE
     BEGIN
          M4:=LY;
          M6:=UY;
     END;
     Mouse;
END;

PROCEDURE DoubleSpeedThreshold(Mickey:Word);
BEGIN
     M1:=19;
     M4:=Mickey;
     Mouse;
END;

PROCEDURE MouseCallExit;
BEGIN
     InLine($5D/$58/$89/$EC/$5D/$07/$1F/$5F/$5E/$5A/$59/$5B/$58/$CB);
END;

PROCEDURE UserHandlerCall(Mask,Button,X,Y:Word);
InLine($FF/$1E/MouseHandler);

PROCEDURE MouseInterrupt(Flags,CS,IP,AX,BX,CX,DX,SI,DI,ES,BP:Word); INTERRUPT;
BEGIN
     UserHandlerCall(AX,BX,CX,DX);
     MouseCallExit;
END;

PROCEDURE SetMouseProcedure(M:Word; P:Pointer);
BEGIN
     M1:=12;
     M3:=M;
     M4:=Ofs(MouseInterrupt);
     SegPointer:=Seg(MouseInterrupt);
     MouseHandler:=P;
     Mouse;
END;


FUNCTION BitInvert(B:Word):Word;
InLine($58/$B9/$10/$00/$33/$DB/$D1/$D0/$D1/$DB/$E2/$FA/$8B/$C3);

PROCEDURE CursorMirror(VAR S,D:MaskRec; F:Byte);
VAR
   I,K:Byte;
BEGIN
     FOR I:=0 TO 1 DO
     BEGIN
          FOR K:=0 TO 15 DO
          BEGIN
               IF (F AND 1)>0 THEN
                  D.Mask[I,K]:=S.Mask[I,15-K]
               ELSE D.Mask[I,K]:=S.Mask[I,K];
               IF (F AND 2)>0 THEN
                  D.Mask[I,K]:=BitInvert(D.Mask[I,K]);
          END;
     END;
     IF (F AND 1)>0 THEN
        D.Y:=15-S.Y
     ELSE D.Y:=S.Y;
     IF (F AND 2)>0 THEN
        D.X:=15-S.X
     ELSE D.X:=S.X;
END;

PROCEDURE ResetMouse;
VAR
   Size:Word;
   Save:Boolean;
BEGIN
     Hercules:=Mem[$40:$49]=7;
     M1:=0;
     Mouse;
     MaxX:=639;
     MaxY:=199;
     SetHorizontalRange(0,MaxX);
     SetVerticalRange(0,MaxY);
END;

PROCEDURE CallOld1B;
InLine($9C/$FF/$1E/Int1BSave);

{$F+ }
PROCEDURE Int1B; INTERRUPT;
{$F- }
BEGIN
     SetIntVec($1B,Int1BSave);
     CallOld1B;
     AboFlag:=TRUE;
END;

{$F+ }
PROCEDURE MouseExit;
{$F- }
BEGIN
     M1:=0;
     Mouse;
     NoSound;
     IF Hercules THEN
        CrtMode:=7;
     ExitProc:=ExitSave;
END;

BEGIN
     M1:=0;
     Mouse;
     IF NOT (M1=65535) THEN
     BEGIN
          ClrScr;
          GotoXY(20,12);
          Write('MS Maustreiber nicht installiert !');
          Halt(1);
     END;
     MaxX:=79;
     MaxY:=24;
     ClrScr;
     CursorMirror(LeftArrowCursor,RightArrowCursor,2);
     CursorMirror(UpArrowCursor,DownArrowCursor,1);
     CursorMirror(StandardCursor,InvertedCursor,3);
     ExitSave:=ExitProc;
     ExitProc:=@MouseExit;
     GetIntVec($1B,Int1BSave);
     SetIntVec($1B,@Int1B);
END.
