;
; Some basic functions for work w/ VBE 1.2/2.0...
; written by Blaz Novak, 16. jun. 1998
;

.586p
.model flat, C
assume cs: flat, ds: flat, es: flat, fs: flat, gs: flat, ss: flat

	OK EQU 0h
	MODESETFAIL EQU 10h
	SETDSTARTFAIL EQU 11h
	
ModeInfoBlock struc                   ;data about selected mode         
	ModeAttributes      dw 0      ; mode attributes
	WinAAttributes      db 0      ; window A attributes
	WinBAttributes      db 0      ; window B attributes
	WinGranularity      dw 0      ; window granularity
	WinSize             dw 0      ; window size
	WinASegment         dw 0      ; window A start segment
	WinBSegment         dw 0      ; window B start segment
	WinFuncPtr          dd 0      ; pointer to window function
	BytesPerScanLine    dw 0      ; bytes per scan line
	XResolution         dw 0      ; horizontal resolution in pixels or chars
	YResolution         dw 0      ; vertical resolution in pixels or chars
	XCharSize           db 0      ; character cell width in pixels
	YCharSize           db 0      ; character cell height in pixels
	NumberOfPlanes      db 0      ; number of memory planes
	BitsPerPixel        db 0      ; bits per pixel
	NumberOfBanks       db 0      ; number of banks
	MemoryModel         db 0      ; memory model type
	BankSize            db 0      ; bank size in KB
	NumberOfImagePages  db 0      ; number of images
	ReservedMIB1        db 0      ; reserved for page function
	RedMaskSize         db 0      ; size of direct color red mask in bits
	RedFieldPosition    db 0      ; bit position of lsb of red mask
	GreenMaskSize       db 0      ; size of direct color green mask in bits
	GreenFieldPosition  db 0      ; bit position of lsb of green mask
	BlueMaskSize        db 0      ; size of direct color blue mask in bits
	BlueFieldPosition   db 0      ; bit position of lsb of blue mask
	RsvdMaskSize        db 0      ; size of direct color reserved mask in bits
	RsvdFieldPosition   db 0      ; bit position of lsb of reserved mask
	DirectColorModeInfo db 0      ; direct color mode attributes
	PhysBasePtr         dd 0      ; physical address for linear frame buffer
	OffScreenMemOffset  dd 0      ; pointer to start of off screen memory
	OffScreenMemSize    dw 0      ; amount of off screen memory in 1k units
	ReservedMIB2        db 206 dup (0)  ; remainder of ModeInfoBlock
ModeInfoBlock ends											       

code segment para public 'code' USE32
	extrn _linearfb:DWORD
	extrn _linear1:DWORD
	extrn _linear2:DWORD
	extrn _vbeerror:DWORD
	extrn _dosmemseg:WORD
	extrn _dosselect:WORD
	extrn _pmodefunc:DWORD
	extrn _sdstart:DWORD
	extrn _modeblock:DWORD
	extrn _vbeinfoblock:DWORD
	extrn _ismap:BYTE
	extrn _vbe2p:BYTE
	extrn _Xres:WORD
	extrn _Yres:WORD
	extrn _Bpp:BYTE
	extrn VBEinit_:PROC
	extrn VBEgetmodeinfo_:PROC
	extrn VBEsetmode_:PROC
	extrn VBEswappage_:PROC
	extrn VBEend_:PROC
	extrn VBE12memcpy_:PROC

BVesaInit_ proc
	call [VBEinit_]
	ret
BVesaInit_ endp

BVesaGetmodeinfo_ proc
	call [VBEgetmodeinfo_]
	ret
BVesaGetmodeinfo_ endp

BVesaSetmode_ proc
	pusha
	mov dword ptr _vbeerror, OK
	mov bl, byte ptr _vbe2p
	cmp bl, 1
	jb vbe12setmode
	call [VBEsetmode_]
	jmp msetok
vbe12setmode:
	and ax, 07fffh
	mov bx, ax
	mov ax, 4f02h
	int 10h
	cmp al, 4fh
	je msetok
	mov dword ptr _vbeerror, MODESETFAIL
msetok:	popa
	mov eax, dword ptr _vbeerror
	ret
BVesaSetmode_ endp

BVesaSetscan_ proc ;takes new scanline length; returns new scanline count
	push ecx
	push ebx
	push edx
	mov ecx, eax
	and ecx, 0ffffh
	mov ax, 4f06h
	mov bx, 0
	int 10h
	mov eax, ecx
	pop edx
	pop ebx
	pop ecx
	ret
BVesaSetscan_ endp

BVesaSetdisp_ proc
	pusha
	mov dword ptr _vbeerror, OK
	cmp ebx, 0                     ;wait for vertical retrace?
	je novret		       ;no
	mov bx, 80h		       ;yes
novret:	mov al, byte ptr _vbe2p        ; x => discarded	       
	cmp al, 1		       ; if (vbe2p)
	jnb vbe2sds		       ; vbe2 setdisplaystart
	mov ecx, 0 		       ; vbe1.2 setdisplaystart
	and edx, 0ffffh
	mov ax, 4f07h
	int 10h
	cmp al, 4fh
	je sdsend
	mov byte ptr _vbeerror, SETDSTARTFAIL
	jmp sdsend
vbe2sds:mov ax, word ptr _Xres
	mul dx            ;dx:ax=Xres*y
	and eax, 0ffffh
	shl edx, 16
	add eax, edx 
	mov dl, byte ptr _Bpp
	and edx, 0ffh
	mul edx           ;=> edx:eax -> eax
	shr eax, 2        ;nobody knows why...
	mov cx, ax
	shr eax, 16
	mov dx, ax
	and ecx, 0ffffh
	and edx, 0ffffh
	mov ax, 4f07h
	call [_sdstart]
sdsend:	popa
	mov eax, dword ptr _vbeerror
	ret
BVesaSetdisp_ endp

VBE12setwindow_ proc
	push eax
	push ebx
	push edx
	mov edx, eax
	and edx, 0ffffh
	mov ax, 4f05h
	mov bx, 0
	int 10h
	pop edx
	pop ebx
	pop eax
	ret
VBE12setwindow_ endp

BVesaCpymem_ proc
	mov _vbeerror, OK
	call [VBE12memcpy_]
	mov eax, _vbeerror
	ret
BVesaCpymem_ endp

BVesaEnd_ proc
	call [VBEend_]
	ret
BVesaEnd_ endp

public BVesaInit_
public BVesaGetmodeinfo_
public BVesaSetmode_
public BVesaSetdisp_
public BVesaSetscan_
public BVesaCpymem_
public BVesaEnd_
public VBE12setwindow_
code ends
end